import { ITranslator } from '@jupyterlab/translation';
import { IDisposable } from '@lumino/disposable';
import { ISignal } from '@lumino/signaling';
import { Widget } from '@lumino/widgets';
import { ISearchProvider, ISearchProviderFactory, ISearchProviderRegistry } from './tokens';
/**
 * Search provider registry
 */
export declare class SearchProviderRegistry implements ISearchProviderRegistry {
    protected translator: ITranslator;
    /**
     * Constructor
     *
     * @param translator Application translator object
     */
    constructor(translator?: ITranslator);
    /**
     * Add a provider to the registry.
     *
     * @param key - The provider key.
     * @returns A disposable delegate that, when disposed, deregisters the given search provider
     */
    add<T extends Widget = Widget>(key: string, provider: ISearchProviderFactory<T>): IDisposable;
    /**
     * Returns a matching provider for the widget.
     *
     * @param widget - The widget to search over.
     * @returns the search provider, or undefined if none exists.
     */
    getProvider(widget: Widget): ISearchProvider | undefined;
    /**
     * Whether the registry as a matching provider for the widget.
     *
     * @param widget - The widget to search over.
     * @returns Provider existence
     */
    hasProvider(widget: Widget): boolean;
    /**
     * Signal that emits when a new search provider has been registered
     * or removed.
     */
    get changed(): ISignal<this, void>;
    private _changed;
    private _providerMap;
}
