/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
import React from 'react';
import { LabIcon } from '../icon';
import { classes } from '../utils';
/**
 * InputGroup component
 *
 * @param props Component properties
 * @returns Component
 */
export function InputGroup(props) {
    const { className, inputRef, rightIcon, ...others } = props;
    return (React.createElement("div", { className: classes('jp-InputGroup', className) },
        React.createElement("input", { ref: inputRef, ...others }),
        rightIcon && (React.createElement("span", { className: "jp-InputGroupAction" }, typeof rightIcon === 'string' ? (React.createElement(LabIcon.resolveReact, { icon: rightIcon, elementPosition: "center", tag: "span" })) : (React.createElement(rightIcon.react, { elementPosition: "center", tag: "span" }))))));
}
//# sourceMappingURL=inputgroup.js.map