import { Widget } from '@lumino/widgets';
/**
 * A Lumino widget which wraps an IFrame.
 */
export declare class IFrame extends Widget {
    /**
     * Create a new IFrame widget.
     */
    constructor(options?: IFrame.IOptions);
    /**
     * Referrer policy for the iframe.
     *
     * #### Notes
     * By default, `no-referrer` is chosen.
     *
     * For more information, see
     * https://developer.mozilla.org/en-US/docs/Web/API/HTMLIFrameElement/referrerPolicy
     */
    get referrerPolicy(): IFrame.ReferrerPolicy;
    set referrerPolicy(value: IFrame.ReferrerPolicy);
    /**
     * Exceptions to the sandboxing.
     *
     * #### Notes
     * By default, all sandboxing security policies are enabled.
     * This setting allows the user to selectively disable these
     * policies. This should be done with care, as it can
     * introduce security risks, and possibly allow malicious
     * sites to execute code in a JupyterLab session.
     *
     * For more information, see
     * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe
     */
    get sandbox(): IFrame.SandboxExceptions[];
    set sandbox(values: IFrame.SandboxExceptions[]);
    /**
     * The url of the IFrame.
     */
    get url(): string;
    set url(url: string);
    private _sandbox;
    private _referrerPolicy;
}
/**
 * A namespace for IFrame widget statics.
 */
export declare namespace IFrame {
    /**
     * Referrer policy for the iframe.
     *
     * User documentation for the policies can be found here:
     * https://developer.mozilla.org/en-US/docs/Web/API/HTMLIFrameElement/referrerPolicy
     */
    type ReferrerPolicy = 'no-referrer' | 'no-referrer-when-downgrade' | 'origin' | 'origin-when-cross-origin' | 'same-origin' | 'strict-origin' | 'strict-origin-when-cross-origin' | 'unsafe-url';
    /**
     * Exceptions to the iframe sandboxing policies.
     * These are specified here:
     * https://www.w3.org/TR/2011/WD-html5-20110525/the-iframe-element.html#attr-iframe-sandbox
     *
     * More user-friendly documentation can be found here:
     * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox
     */
    type SandboxExceptions = 'allow-downloads' | 'allow-forms' | 'allow-modals' | 'allow-orientation-lock' | 'allow-pointer-lock' | 'allow-popups' | 'popups-to-escape-sandbox' | 'allow-presentation' | 'allow-same-origin' | 'allow-scripts' | 'allow-storage-access-by-user-activation' | 'allow-top-navigation' | 'allow-top-navigation-by-user-activation';
    /**
     * Options for creating a new IFrame widget.
     */
    interface IOptions {
        /**
         * Exceptions for the iframe sandbox.
         */
        sandbox?: SandboxExceptions[];
        /**
         * Referrer policy for the iframe.
         */
        referrerPolicy?: ReferrerPolicy;
    }
}
