import { ITranslator } from '@jupyterlab/translation';
import { ReadonlyJSONObject } from '@lumino/coreutils';
import { FormProps, IChangeEvent } from '@rjsf/core';
import { ArrayFieldTemplateProps } from '@rjsf/utils';
import React from 'react';
/**
 * Default `ui:options` for the UiSchema.
 */
export declare const DEFAULT_UI_OPTIONS: {
    /**
     * This prevents the submit button from being rendered, by default, as it is
     * almost never what is wanted.
     *
     * Provide any `uiSchema#/ui:options/submitButtonOptions` to override this.
     */
    submitButtonOptions: {
        norender: boolean;
    };
};
/**
 * Form component namespace.
 */
export declare namespace FormComponent {
    interface IButtonProps {
        /**
         * Button style.
         */
        buttonStyle?: 'icons' | 'text';
        /**
         * Translator for button text.
         */
        translator?: ITranslator;
    }
    /**
     * Properties for React JSON schema form's container template (array and object).
     */
    interface ILabCustomizerProps extends IButtonProps {
        /**
         * Whether the container is in compact mode or not.
         * In compact mode the title and description are displayed more compactness.
         */
        compact?: boolean;
        /**
         * Whether to display if the current value is not the default one.
         */
        showModifiedFromDefault?: boolean;
    }
    /**
     * Properties of the button to move an item.
     */
    interface IMoveButtonProps extends IButtonProps {
        /**
         * Item index to move with this button.
         */
        item: ArrayFieldTemplateProps['items'][number];
        /**
         * Direction in which to move the item.
         */
        direction: 'up' | 'down';
    }
    /**
     * Properties of the button to drop an item.
     */
    interface IDropButtonProps extends IButtonProps {
        /**
         * Item index to drop with this button.
         */
        item: ArrayFieldTemplateProps['items'][number];
    }
    /**
     * Properties of the button to add an item.
     */
    interface IAddButtonProps extends IButtonProps {
        /**
         * Function to call to add an item.
         */
        onAddClick: ArrayFieldTemplateProps['onAddClick'];
    }
}
/**
 * Button to move an item.
 *
 * @returns - the button as a react element.
 */
export declare const MoveButton: (props: FormComponent.IMoveButtonProps) => JSX.Element;
/**
 * Button to drop an item.
 *
 * @returns - the button as a react element.
 */
export declare const DropButton: (props: FormComponent.IDropButtonProps) => JSX.Element;
/**
 * Button to add an item.
 *
 * @returns - the button as a react element.
 */
export declare const AddButton: (props: FormComponent.IAddButtonProps) => JSX.Element;
export interface ILabCustomizerOptions<P> extends FormComponent.ILabCustomizerProps {
    name?: string;
    component: React.FunctionComponent<P & Required<FormComponent.ILabCustomizerProps>>;
}
/**
 * FormComponent properties
 */
export interface IFormComponentProps<T = ReadonlyJSONObject> extends FormProps<T>, FormComponent.ILabCustomizerProps {
    /**
     *
     */
    formData: T;
    /**
     *
     */
    onChange: (e: IChangeEvent<T>) => any;
    /**
     *
     */
    formContext?: unknown;
}
/**
 * Generic rjsf form component for JupyterLab UI.
 */
export declare function FormComponent(props: IFormComponentProps): JSX.Element;
