import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { Component, useState, useCallback, useEffect, useReducer, useMemo, createRef, forwardRef } from 'react';
import { isFixedItems, allowAdditionalItems, getUiOptions, ITEMS_KEY, getTemplate, TranslatableString, isCustomWidget, getWidget, optionsList, deepEquals, ERRORS_KEY, asNumber, REF_KEY, orderProperties, PROPERTIES_KEY, ADDITIONAL_PROPERTY_FLAG, ANY_OF_KEY, ONE_OF_KEY, mergeObjects, UI_OPTIONS_KEY, descriptionId, getSchemaType, ID_KEY, hasWidget, titleId, getInputProps, examplesId, ariaDescribedByIds, getSubmitButtonOptions, errorId, helpId, canExpand, parseDateString, toDateString, pad, schemaRequiresTrueValue, enumOptionsValueForIndex, enumOptionsIsSelected, optionId, enumOptionsSelectValue, enumOptionsDeselectValue, utcToLocal, localToUTC, dataURItoBlob, enumOptionsIndexForValue, englishStringTranslator, createSchemaUtils, shouldRender, isObject as isObject$1, RJSF_ADDITONAL_PROPERTIES_FLAG, NAME_KEY } from '@rjsf/utils';
import get from 'lodash-es/get';
import isEmpty from 'lodash-es/isEmpty';
import _pick from 'lodash-es/pick';
import _toPath from 'lodash-es/toPath';
import isObject from 'lodash-es/isObject';
import set from 'lodash-es/set';
import { nanoid } from 'nanoid';
import omit from 'lodash-es/omit';
import has from 'lodash-es/has';
import unset from 'lodash-es/unset';
import Markdown from 'markdown-to-jsx';

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}

var _excluded$9 = ["widget"],
  _excluded2 = ["widget"],
  _excluded3 = ["widget"];
/** Used to generate a unique ID for an element in a row */
function generateRowId() {
  return nanoid();
}
/** Converts the `formData` into `KeyedFormDataType` data, using the `generateRowId()` function to create the key
 *
 * @param formData - The data for the form
 * @returns - The `formData` converted into a `KeyedFormDataType` element
 */
function generateKeyedFormData(formData) {
  return !Array.isArray(formData) ? [] : formData.map(function (item) {
    return {
      key: generateRowId(),
      item: item
    };
  });
}
/** Converts `KeyedFormDataType` data into the inner `formData`
 *
 * @param keyedFormData - The `KeyedFormDataType` to be converted
 * @returns - The inner `formData` item(s) in the `keyedFormData`
 */
function keyedToPlainFormData(keyedFormData) {
  if (Array.isArray(keyedFormData)) {
    return keyedFormData.map(function (keyedItem) {
      return keyedItem.item;
    });
  }
  return [];
}
/** The `ArrayField` component is used to render a field in the schema that is of type `array`. It supports both normal
 * and fixed array, allowing user to add and remove elements from the array data.
 */
var ArrayField = /*#__PURE__*/function (_Component) {
  _inheritsLoose(ArrayField, _Component);
  /** Constructs an `ArrayField` from the `props`, generating the initial keyed data from the `formData`
   *
   * @param props - The `FieldProps` for this template
   */
  function ArrayField(props) {
    var _this;
    _this = _Component.call(this, props) || this;
    _this._getNewFormDataRow = function () {
      var _this$props = _this.props,
        schema = _this$props.schema,
        registry = _this$props.registry;
      var schemaUtils = registry.schemaUtils;
      var itemSchema = schema.items;
      if (isFixedItems(schema) && allowAdditionalItems(schema)) {
        itemSchema = schema.additionalItems;
      }
      // Cast this as a T to work around schema utils being for T[] caused by the FieldProps<T[], S, F> call on the class
      return schemaUtils.getDefaultFormState(itemSchema);
    };
    _this.onAddClick = function (event) {
      _this._handleAddClick(event);
    };
    _this.onAddIndexClick = function (index) {
      return function (event) {
        _this._handleAddClick(event, index);
      };
    };
    _this.onDropIndexClick = function (index) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }
        var _this$props2 = _this.props,
          onChange = _this$props2.onChange,
          errorSchema = _this$props2.errorSchema;
        var keyedFormData = _this.state.keyedFormData;
        // refs #195: revalidate to ensure properly reindexing errors
        var newErrorSchema;
        if (errorSchema) {
          newErrorSchema = {};
          for (var idx in errorSchema) {
            var i = parseInt(idx);
            if (i < index) {
              set(newErrorSchema, [i], errorSchema[idx]);
            } else if (i > index) {
              set(newErrorSchema, [i - 1], errorSchema[idx]);
            }
          }
        }
        var newKeyedFormData = keyedFormData.filter(function (_, i) {
          return i !== index;
        });
        _this.setState({
          keyedFormData: newKeyedFormData,
          updatedKeyedFormData: true
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    };
    _this.onReorderClick = function (index, newIndex) {
      return function (event) {
        if (event) {
          event.preventDefault();
          event.currentTarget.blur();
        }
        var _this$props3 = _this.props,
          onChange = _this$props3.onChange,
          errorSchema = _this$props3.errorSchema;
        var newErrorSchema;
        if (errorSchema) {
          newErrorSchema = {};
          for (var idx in errorSchema) {
            var i = parseInt(idx);
            if (i == index) {
              set(newErrorSchema, [newIndex], errorSchema[index]);
            } else if (i == newIndex) {
              set(newErrorSchema, [index], errorSchema[newIndex]);
            } else {
              set(newErrorSchema, [idx], errorSchema[i]);
            }
          }
        }
        var keyedFormData = _this.state.keyedFormData;
        function reOrderArray() {
          // Copy item
          var _newKeyedFormData = keyedFormData.slice();
          // Moves item from index to newIndex
          _newKeyedFormData.splice(index, 1);
          _newKeyedFormData.splice(newIndex, 0, keyedFormData[index]);
          return _newKeyedFormData;
        }
        var newKeyedFormData = reOrderArray();
        _this.setState({
          keyedFormData: newKeyedFormData
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    };
    _this.onChangeForIndex = function (index) {
      return function (value, newErrorSchema, id) {
        var _extends2;
        var _this$props4 = _this.props,
          formData = _this$props4.formData,
          onChange = _this$props4.onChange,
          errorSchema = _this$props4.errorSchema;
        var arrayData = Array.isArray(formData) ? formData : [];
        var newFormData = arrayData.map(function (item, i) {
          // We need to treat undefined items as nulls to have validation.
          // See https://github.com/tdegrunt/jsonschema/issues/206
          var jsonValue = typeof value === 'undefined' ? null : value;
          return index === i ? jsonValue : item;
        });
        onChange(newFormData, errorSchema && errorSchema && _extends({}, errorSchema, (_extends2 = {}, _extends2[index] = newErrorSchema, _extends2)), id);
      };
    };
    _this.onSelectChange = function (value) {
      var _this$props5 = _this.props,
        onChange = _this$props5.onChange,
        idSchema = _this$props5.idSchema;
      onChange(value, undefined, idSchema && idSchema.$id);
    };
    var _props$formData = props.formData,
      _formData = _props$formData === void 0 ? [] : _props$formData;
    var _keyedFormData = generateKeyedFormData(_formData);
    _this.state = {
      keyedFormData: _keyedFormData,
      updatedKeyedFormData: false
    };
    return _this;
  }
  /** React lifecycle method that is called when the props are about to change allowing the state to be updated. It
   * regenerates the keyed form data and returns it
   *
   * @param nextProps - The next set of props data
   * @param prevState - The previous set of state data
   */
  ArrayField.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, prevState) {
    // Don't call getDerivedStateFromProps if keyed formdata was just updated.
    if (prevState.updatedKeyedFormData) {
      return {
        updatedKeyedFormData: false
      };
    }
    var nextFormData = Array.isArray(nextProps.formData) ? nextProps.formData : [];
    var previousKeyedFormData = prevState.keyedFormData || [];
    var newKeyedFormData = nextFormData.length === previousKeyedFormData.length ? previousKeyedFormData.map(function (previousKeyedFormDatum, index) {
      return {
        key: previousKeyedFormDatum.key,
        item: nextFormData[index]
      };
    }) : generateKeyedFormData(nextFormData);
    return {
      keyedFormData: newKeyedFormData
    };
  }
  /** Returns the appropriate title for an item by getting first the title from the schema.items, then falling back to
   * the description from the schema.items, and finally the string "Item"
   */;
  var _proto = ArrayField.prototype;
  /** Determines whether the item described in the schema is always required, which is determined by whether any item
   * may be null.
   *
   * @param itemSchema - The schema for the item
   * @return - True if the item schema type does not contain the "null" type
   */
  _proto.isItemRequired = function isItemRequired(itemSchema) {
    if (Array.isArray(itemSchema.type)) {
      // While we don't yet support composite/nullable jsonschema types, it's
      // future-proof to check for requirement against these.
      return !itemSchema.type.includes('null');
    }
    // All non-null array item types are inherently required by design
    return itemSchema.type !== 'null';
  }
  /** Determines whether more items can be added to the array. If the uiSchema indicates the array doesn't allow adding
   * then false is returned. Otherwise, if the schema indicates that there are a maximum number of items and the
   * `formData` matches that value, then false is returned, otherwise true is returned.
   *
   * @param formItems - The list of items in the form
   * @returns - True if the item is addable otherwise false
   */;
  _proto.canAddItem = function canAddItem(formItems) {
    var _this$props6 = this.props,
      schema = _this$props6.schema,
      uiSchema = _this$props6.uiSchema;
    var _getUiOptions = getUiOptions(uiSchema),
      addable = _getUiOptions.addable;
    if (addable !== false) {
      // if ui:options.addable was not explicitly set to false, we can add
      // another item if we have not exceeded maxItems yet
      if (schema.maxItems !== undefined) {
        addable = formItems.length < schema.maxItems;
      } else {
        addable = true;
      }
    }
    return addable;
  }
  /** Returns the default form information for an item based on the schema for that item. Deals with the possibility
   * that the schema is fixed and allows additional items.
   */;
  /** Callback handler for when the user clicks on the add or add at index buttons. Creates a new row of keyed form data
   * either at the end of the list (when index is not specified) or inserted at the `index` when it is, adding it into
   * the state, and then returning `onChange()` with the plain form data converted from the keyed data
   *
   * @param event - The event for the click
   * @param [index] - The optional index at which to add the new data
   */
  _proto._handleAddClick = function _handleAddClick(event, index) {
    if (event) {
      event.preventDefault();
    }
    var onChange = this.props.onChange;
    var keyedFormData = this.state.keyedFormData;
    var newKeyedFormDataRow = {
      key: generateRowId(),
      item: this._getNewFormDataRow()
    };
    var newKeyedFormData = [].concat(keyedFormData);
    if (index !== undefined) {
      newKeyedFormData.splice(index, 0, newKeyedFormDataRow);
    } else {
      newKeyedFormData.push(newKeyedFormDataRow);
    }
    this.setState({
      keyedFormData: newKeyedFormData,
      updatedKeyedFormData: true
    }, function () {
      return onChange(keyedToPlainFormData(newKeyedFormData));
    });
  }
  /** Callback handler for when the user clicks on the add button. Creates a new row of keyed form data at the end of
   * the list, adding it into the state, and then returning `onChange()` with the plain form data converted from the
   * keyed data
   *
   * @param event - The event for the click
   */;
  /** Renders the `ArrayField` depending on the specific needs of the schema and uischema elements
   */
  _proto.render = function render() {
    var _this$props7 = this.props,
      schema = _this$props7.schema,
      uiSchema = _this$props7.uiSchema,
      idSchema = _this$props7.idSchema,
      registry = _this$props7.registry;
    var schemaUtils = registry.schemaUtils,
      translateString = registry.translateString;
    if (!(ITEMS_KEY in schema)) {
      var uiOptions = getUiOptions(uiSchema);
      var UnsupportedFieldTemplate = getTemplate('UnsupportedFieldTemplate', registry, uiOptions);
      return jsx(UnsupportedFieldTemplate, {
        schema: schema,
        idSchema: idSchema,
        reason: translateString(TranslatableString.MissingItems),
        registry: registry
      });
    }
    if (schemaUtils.isMultiSelect(schema)) {
      // If array has enum or uniqueItems set to true, call renderMultiSelect() to render the default multiselect widget or a custom widget, if specified.
      return this.renderMultiSelect();
    }
    if (isCustomWidget(uiSchema)) {
      return this.renderCustomWidget();
    }
    if (isFixedItems(schema)) {
      return this.renderFixedArray();
    }
    if (schemaUtils.isFilesArray(schema, uiSchema)) {
      return this.renderFiles();
    }
    return this.renderNormalArray();
  }
  /** Renders a normal array without any limitations of length
   */;
  _proto.renderNormalArray = function renderNormalArray() {
    var _this2 = this;
    var _this$props8 = this.props,
      schema = _this$props8.schema,
      _this$props8$uiSchema = _this$props8.uiSchema,
      uiSchema = _this$props8$uiSchema === void 0 ? {} : _this$props8$uiSchema,
      errorSchema = _this$props8.errorSchema,
      idSchema = _this$props8.idSchema,
      name = _this$props8.name,
      _this$props8$disabled = _this$props8.disabled,
      disabled = _this$props8$disabled === void 0 ? false : _this$props8$disabled,
      _this$props8$readonly = _this$props8.readonly,
      readonly = _this$props8$readonly === void 0 ? false : _this$props8$readonly,
      _this$props8$autofocu = _this$props8.autofocus,
      autofocus = _this$props8$autofocu === void 0 ? false : _this$props8$autofocu,
      _this$props8$required = _this$props8.required,
      required = _this$props8$required === void 0 ? false : _this$props8$required,
      registry = _this$props8.registry,
      onBlur = _this$props8.onBlur,
      onFocus = _this$props8.onFocus,
      idPrefix = _this$props8.idPrefix,
      _this$props8$idSepara = _this$props8.idSeparator,
      idSeparator = _this$props8$idSepara === void 0 ? '_' : _this$props8$idSepara,
      rawErrors = _this$props8.rawErrors;
    var keyedFormData = this.state.keyedFormData;
    var title = schema.title === undefined ? name : schema.title;
    var schemaUtils = registry.schemaUtils,
      formContext = registry.formContext;
    var uiOptions = getUiOptions(uiSchema);
    var _schemaItems = isObject(schema.items) ? schema.items : {};
    var itemsSchema = schemaUtils.retrieveSchema(_schemaItems);
    var formData = keyedToPlainFormData(this.state.keyedFormData);
    var canAdd = this.canAddItem(formData);
    var arrayProps = {
      canAdd: canAdd,
      items: keyedFormData.map(function (keyedItem, index) {
        var key = keyedItem.key,
          item = keyedItem.item;
        // While we are actually dealing with a single item of type T, the types require a T[], so cast
        var itemCast = item;
        var itemSchema = schemaUtils.retrieveSchema(_schemaItems, itemCast);
        var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
        var itemIdPrefix = idSchema.$id + idSeparator + index;
        var itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);
        return _this2.renderArrayFieldItem({
          key: key,
          index: index,
          name: name && name + "-" + index,
          canAdd: canAdd,
          canMoveUp: index > 0,
          canMoveDown: index < formData.length - 1,
          itemSchema: itemSchema,
          itemIdSchema: itemIdSchema,
          itemErrorSchema: itemErrorSchema,
          itemData: itemCast,
          itemUiSchema: uiSchema.items,
          autofocus: autofocus && index === 0,
          onBlur: onBlur,
          onFocus: onFocus,
          rawErrors: rawErrors,
          totalItems: keyedFormData.length
        });
      }),
      className: "field field-array field-array-of-" + itemsSchema.type,
      disabled: disabled,
      idSchema: idSchema,
      uiSchema: uiSchema,
      onAddClick: this.onAddClick,
      readonly: readonly,
      required: required,
      schema: schema,
      title: title,
      formContext: formContext,
      formData: formData,
      rawErrors: rawErrors,
      registry: registry
    };
    var Template = getTemplate('ArrayFieldTemplate', registry, uiOptions);
    return jsx(Template, _extends({}, arrayProps));
  }
  /** Renders an array using the custom widget provided by the user in the `uiSchema`
   */;
  _proto.renderCustomWidget = function renderCustomWidget() {
    var _this$props9 = this.props,
      schema = _this$props9.schema,
      idSchema = _this$props9.idSchema,
      uiSchema = _this$props9.uiSchema,
      _this$props9$disabled = _this$props9.disabled,
      disabled = _this$props9$disabled === void 0 ? false : _this$props9$disabled,
      _this$props9$readonly = _this$props9.readonly,
      readonly = _this$props9$readonly === void 0 ? false : _this$props9$readonly,
      _this$props9$autofocu = _this$props9.autofocus,
      autofocus = _this$props9$autofocu === void 0 ? false : _this$props9$autofocu,
      _this$props9$required = _this$props9.required,
      required = _this$props9$required === void 0 ? false : _this$props9$required,
      hideError = _this$props9.hideError,
      placeholder = _this$props9.placeholder,
      onBlur = _this$props9.onBlur,
      onFocus = _this$props9.onFocus,
      _this$props9$formData = _this$props9.formData,
      items = _this$props9$formData === void 0 ? [] : _this$props9$formData,
      registry = _this$props9.registry,
      rawErrors = _this$props9.rawErrors,
      name = _this$props9.name;
    var widgets = registry.widgets,
      formContext = registry.formContext;
    var title = schema.title || name;
    var _getUiOptions2 = getUiOptions(uiSchema),
      widget = _getUiOptions2.widget,
      options = _objectWithoutPropertiesLoose(_getUiOptions2, _excluded$9);
    var Widget = getWidget(schema, widget, widgets);
    return jsx(Widget, {
      id: idSchema.$id,
      name: name,
      multiple: true,
      onChange: this.onSelectChange,
      onBlur: onBlur,
      onFocus: onFocus,
      options: options,
      schema: schema,
      uiSchema: uiSchema,
      registry: registry,
      value: items,
      disabled: disabled,
      readonly: readonly,
      hideError: hideError,
      required: required,
      label: title,
      placeholder: placeholder,
      formContext: formContext,
      autofocus: autofocus,
      rawErrors: rawErrors
    });
  }
  /** Renders an array as a set of checkboxes
   */;
  _proto.renderMultiSelect = function renderMultiSelect() {
    var _this$props10 = this.props,
      schema = _this$props10.schema,
      idSchema = _this$props10.idSchema,
      uiSchema = _this$props10.uiSchema,
      _this$props10$formDat = _this$props10.formData,
      items = _this$props10$formDat === void 0 ? [] : _this$props10$formDat,
      _this$props10$disable = _this$props10.disabled,
      disabled = _this$props10$disable === void 0 ? false : _this$props10$disable,
      _this$props10$readonl = _this$props10.readonly,
      readonly = _this$props10$readonl === void 0 ? false : _this$props10$readonl,
      _this$props10$autofoc = _this$props10.autofocus,
      autofocus = _this$props10$autofoc === void 0 ? false : _this$props10$autofoc,
      _this$props10$require = _this$props10.required,
      required = _this$props10$require === void 0 ? false : _this$props10$require,
      placeholder = _this$props10.placeholder,
      onBlur = _this$props10.onBlur,
      onFocus = _this$props10.onFocus,
      registry = _this$props10.registry,
      rawErrors = _this$props10.rawErrors,
      name = _this$props10.name;
    var widgets = registry.widgets,
      schemaUtils = registry.schemaUtils,
      formContext = registry.formContext;
    var itemsSchema = schemaUtils.retrieveSchema(schema.items, items);
    var title = schema.title || name;
    var enumOptions = optionsList(itemsSchema);
    var _getUiOptions3 = getUiOptions(uiSchema),
      _getUiOptions3$widget = _getUiOptions3.widget,
      widget = _getUiOptions3$widget === void 0 ? 'select' : _getUiOptions3$widget,
      options = _objectWithoutPropertiesLoose(_getUiOptions3, _excluded2);
    var Widget = getWidget(schema, widget, widgets);
    return jsx(Widget, {
      id: idSchema.$id,
      name: name,
      multiple: true,
      onChange: this.onSelectChange,
      onBlur: onBlur,
      onFocus: onFocus,
      options: _extends({}, options, {
        enumOptions: enumOptions
      }),
      schema: schema,
      uiSchema: uiSchema,
      registry: registry,
      value: items,
      disabled: disabled,
      readonly: readonly,
      required: required,
      label: title,
      placeholder: placeholder,
      formContext: formContext,
      autofocus: autofocus,
      rawErrors: rawErrors
    });
  }
  /** Renders an array of files using the `FileWidget`
   */;
  _proto.renderFiles = function renderFiles() {
    var _this$props11 = this.props,
      schema = _this$props11.schema,
      uiSchema = _this$props11.uiSchema,
      idSchema = _this$props11.idSchema,
      name = _this$props11.name,
      _this$props11$disable = _this$props11.disabled,
      disabled = _this$props11$disable === void 0 ? false : _this$props11$disable,
      _this$props11$readonl = _this$props11.readonly,
      readonly = _this$props11$readonl === void 0 ? false : _this$props11$readonl,
      _this$props11$autofoc = _this$props11.autofocus,
      autofocus = _this$props11$autofoc === void 0 ? false : _this$props11$autofoc,
      _this$props11$require = _this$props11.required,
      required = _this$props11$require === void 0 ? false : _this$props11$require,
      onBlur = _this$props11.onBlur,
      onFocus = _this$props11.onFocus,
      registry = _this$props11.registry,
      _this$props11$formDat = _this$props11.formData,
      items = _this$props11$formDat === void 0 ? [] : _this$props11$formDat,
      rawErrors = _this$props11.rawErrors;
    var title = schema.title || name;
    var widgets = registry.widgets,
      formContext = registry.formContext;
    var _getUiOptions4 = getUiOptions(uiSchema),
      _getUiOptions4$widget = _getUiOptions4.widget,
      widget = _getUiOptions4$widget === void 0 ? 'files' : _getUiOptions4$widget,
      options = _objectWithoutPropertiesLoose(_getUiOptions4, _excluded3);
    var Widget = getWidget(schema, widget, widgets);
    return jsx(Widget, {
      options: options,
      id: idSchema.$id,
      name: name,
      multiple: true,
      onChange: this.onSelectChange,
      onBlur: onBlur,
      onFocus: onFocus,
      schema: schema,
      uiSchema: uiSchema,
      title: title,
      value: items,
      disabled: disabled,
      readonly: readonly,
      required: required,
      registry: registry,
      formContext: formContext,
      autofocus: autofocus,
      rawErrors: rawErrors,
      label: ''
    });
  }
  /** Renders an array that has a maximum limit of items
   */;
  _proto.renderFixedArray = function renderFixedArray() {
    var _this3 = this;
    var _this$props12 = this.props,
      schema = _this$props12.schema,
      _this$props12$uiSchem = _this$props12.uiSchema,
      uiSchema = _this$props12$uiSchem === void 0 ? {} : _this$props12$uiSchem,
      _this$props12$formDat = _this$props12.formData,
      formData = _this$props12$formDat === void 0 ? [] : _this$props12$formDat,
      errorSchema = _this$props12.errorSchema,
      idPrefix = _this$props12.idPrefix,
      _this$props12$idSepar = _this$props12.idSeparator,
      idSeparator = _this$props12$idSepar === void 0 ? '_' : _this$props12$idSepar,
      idSchema = _this$props12.idSchema,
      name = _this$props12.name,
      _this$props12$disable = _this$props12.disabled,
      disabled = _this$props12$disable === void 0 ? false : _this$props12$disable,
      _this$props12$readonl = _this$props12.readonly,
      readonly = _this$props12$readonl === void 0 ? false : _this$props12$readonl,
      _this$props12$autofoc = _this$props12.autofocus,
      autofocus = _this$props12$autofoc === void 0 ? false : _this$props12$autofoc,
      _this$props12$require = _this$props12.required,
      required = _this$props12$require === void 0 ? false : _this$props12$require,
      registry = _this$props12.registry,
      onBlur = _this$props12.onBlur,
      onFocus = _this$props12.onFocus,
      rawErrors = _this$props12.rawErrors;
    var keyedFormData = this.state.keyedFormData;
    var _this$props$formData = this.props.formData,
      items = _this$props$formData === void 0 ? [] : _this$props$formData;
    var title = schema.title || name;
    var uiOptions = getUiOptions(uiSchema);
    var schemaUtils = registry.schemaUtils,
      formContext = registry.formContext;
    var _schemaItems = isObject(schema.items) ? schema.items : [];
    var itemSchemas = _schemaItems.map(function (item, index) {
      return schemaUtils.retrieveSchema(item, formData[index]);
    });
    var additionalSchema = isObject(schema.additionalItems) ? schemaUtils.retrieveSchema(schema.additionalItems, formData) : null;
    if (!items || items.length < itemSchemas.length) {
      // to make sure at least all fixed items are generated
      items = items || [];
      items = items.concat(new Array(itemSchemas.length - items.length));
    }
    // These are the props passed into the render function
    var canAdd = this.canAddItem(items) && !!additionalSchema;
    var arrayProps = {
      canAdd: canAdd,
      className: 'field field-array field-array-fixed-items',
      disabled: disabled,
      idSchema: idSchema,
      formData: formData,
      items: keyedFormData.map(function (keyedItem, index) {
        var key = keyedItem.key,
          item = keyedItem.item;
        // While we are actually dealing with a single item of type T, the types require a T[], so cast
        var itemCast = item;
        var additional = index >= itemSchemas.length;
        var itemSchema = additional && isObject(schema.additionalItems) ? schemaUtils.retrieveSchema(schema.additionalItems, itemCast) : itemSchemas[index];
        var itemIdPrefix = idSchema.$id + idSeparator + index;
        var itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);
        var itemUiSchema = additional ? uiSchema.additionalItems || {} : Array.isArray(uiSchema.items) ? uiSchema.items[index] : uiSchema.items || {};
        var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
        return _this3.renderArrayFieldItem({
          key: key,
          index: index,
          name: name && name + "-" + index,
          canAdd: canAdd,
          canRemove: additional,
          canMoveUp: index >= itemSchemas.length + 1,
          canMoveDown: additional && index < items.length - 1,
          itemSchema: itemSchema,
          itemData: itemCast,
          itemUiSchema: itemUiSchema,
          itemIdSchema: itemIdSchema,
          itemErrorSchema: itemErrorSchema,
          autofocus: autofocus && index === 0,
          onBlur: onBlur,
          onFocus: onFocus,
          rawErrors: rawErrors,
          totalItems: keyedFormData.length
        });
      }),
      onAddClick: this.onAddClick,
      readonly: readonly,
      required: required,
      registry: registry,
      schema: schema,
      uiSchema: uiSchema,
      title: title,
      formContext: formContext,
      rawErrors: rawErrors
    };
    var Template = getTemplate('ArrayFieldTemplate', registry, uiOptions);
    return jsx(Template, _extends({}, arrayProps));
  }
  /** Renders the individual array item using a `SchemaField` along with the additional properties required to be send
   * back to the `ArrayFieldItemTemplate`.
   *
   * @param props - The props for the individual array item to be rendered
   */;
  _proto.renderArrayFieldItem = function renderArrayFieldItem(props) {
    var key = props.key,
      index = props.index,
      name = props.name,
      canAdd = props.canAdd,
      _props$canRemove = props.canRemove,
      canRemove = _props$canRemove === void 0 ? true : _props$canRemove,
      _props$canMoveUp = props.canMoveUp,
      canMoveUp = _props$canMoveUp === void 0 ? true : _props$canMoveUp,
      _props$canMoveDown = props.canMoveDown,
      canMoveDown = _props$canMoveDown === void 0 ? true : _props$canMoveDown,
      itemSchema = props.itemSchema,
      itemData = props.itemData,
      itemUiSchema = props.itemUiSchema,
      itemIdSchema = props.itemIdSchema,
      itemErrorSchema = props.itemErrorSchema,
      autofocus = props.autofocus,
      onBlur = props.onBlur,
      onFocus = props.onFocus,
      rawErrors = props.rawErrors,
      totalItems = props.totalItems;
    var _this$props13 = this.props,
      disabled = _this$props13.disabled,
      hideError = _this$props13.hideError,
      idPrefix = _this$props13.idPrefix,
      idSeparator = _this$props13.idSeparator,
      readonly = _this$props13.readonly,
      uiSchema = _this$props13.uiSchema,
      registry = _this$props13.registry,
      formContext = _this$props13.formContext;
    var _registry$fields = registry.fields,
      ArraySchemaField = _registry$fields.ArraySchemaField,
      SchemaField = _registry$fields.SchemaField;
    var ItemSchemaField = ArraySchemaField || SchemaField;
    var _getUiOptions5 = getUiOptions(uiSchema),
      _getUiOptions5$ordera = _getUiOptions5.orderable,
      orderable = _getUiOptions5$ordera === void 0 ? true : _getUiOptions5$ordera,
      _getUiOptions5$remova = _getUiOptions5.removable,
      removable = _getUiOptions5$remova === void 0 ? true : _getUiOptions5$remova;
    var has = {
      moveUp: orderable && canMoveUp,
      moveDown: orderable && canMoveDown,
      remove: removable && canRemove,
      toolbar: false
    };
    has.toolbar = Object.keys(has).some(function (key) {
      return has[key];
    });
    return {
      children: jsx(ItemSchemaField, {
        name: name,
        index: index,
        schema: itemSchema,
        uiSchema: itemUiSchema,
        formData: itemData,
        formContext: formContext,
        errorSchema: itemErrorSchema,
        idPrefix: idPrefix,
        idSeparator: idSeparator,
        idSchema: itemIdSchema,
        required: this.isItemRequired(itemSchema),
        onChange: this.onChangeForIndex(index),
        onBlur: onBlur,
        onFocus: onFocus,
        registry: registry,
        disabled: disabled,
        readonly: readonly,
        hideError: hideError,
        autofocus: autofocus,
        rawErrors: rawErrors
      }),
      className: 'array-item',
      disabled: disabled,
      canAdd: canAdd,
      hasToolbar: has.toolbar,
      hasMoveUp: has.moveUp,
      hasMoveDown: has.moveDown,
      hasRemove: has.remove,
      index: index,
      totalItems: totalItems,
      key: key,
      onAddIndexClick: this.onAddIndexClick,
      onDropIndexClick: this.onDropIndexClick,
      onReorderClick: this.onReorderClick,
      readonly: readonly,
      registry: registry,
      schema: itemSchema,
      uiSchema: itemUiSchema
    };
  };
  _createClass(ArrayField, [{
    key: "itemTitle",
    get: function get$1() {
      var _this$props14 = this.props,
        schema = _this$props14.schema,
        registry = _this$props14.registry;
      var translateString = registry.translateString;
      return get(schema, [ITEMS_KEY, 'title'], get(schema, [ITEMS_KEY, 'description'], translateString(TranslatableString.ArrayItemTitle)));
    }
  }]);
  return ArrayField;
}(Component);

var _excluded$8 = ["widget"];
/** The `BooleanField` component is used to render a field in the schema is boolean. It constructs `enumOptions` for the
 * two boolean values based on the various alternatives in the schema.
 *
 * @param props - The `FieldProps` for this template
 */
function BooleanField(props) {
  var schema = props.schema,
    name = props.name,
    uiSchema = props.uiSchema,
    idSchema = props.idSchema,
    formData = props.formData,
    registry = props.registry,
    required = props.required,
    disabled = props.disabled,
    readonly = props.readonly,
    autofocus = props.autofocus,
    onChange = props.onChange,
    onFocus = props.onFocus,
    onBlur = props.onBlur,
    rawErrors = props.rawErrors;
  var title = schema.title;
  var widgets = registry.widgets,
    formContext = registry.formContext,
    translateString = registry.translateString;
  var _getUiOptions = getUiOptions(uiSchema),
    _getUiOptions$widget = _getUiOptions.widget,
    widget = _getUiOptions$widget === void 0 ? 'checkbox' : _getUiOptions$widget,
    options = _objectWithoutPropertiesLoose(_getUiOptions, _excluded$8);
  var Widget = getWidget(schema, widget, widgets);
  var yes = translateString(TranslatableString.YesLabel);
  var no = translateString(TranslatableString.NoLabel);
  var enumOptions;
  if (Array.isArray(schema.oneOf)) {
    enumOptions = optionsList({
      oneOf: schema.oneOf.map(function (option) {
        if (isObject(option)) {
          return _extends({}, option, {
            title: option.title || (option["const"] === true ? yes : no)
          });
        }
        return undefined;
      }).filter(function (o) {
        return o;
      }) // cast away the error that typescript can't grok is fixed
    });
  } else {
    var _schema$enum;
    // We deprecated enumNames in v5. It's intentionally omitted from RSJFSchema type, so we need to cast here.
    var schemaWithEnumNames = schema;
    var enums = (_schema$enum = schema["enum"]) != null ? _schema$enum : [true, false];
    if (!schemaWithEnumNames.enumNames && enums.length === 2 && enums.every(function (v) {
      return typeof v === 'boolean';
    })) {
      enumOptions = [{
        value: enums[0],
        label: enums[0] ? yes : no
      }, {
        value: enums[1],
        label: enums[1] ? yes : no
      }];
    } else {
      enumOptions = optionsList({
        "enum": enums,
        // NOTE: enumNames is deprecated, but still supported for now.
        enumNames: schemaWithEnumNames.enumNames
      });
    }
  }
  return jsx(Widget, {
    options: _extends({}, options, {
      enumOptions: enumOptions
    }),
    schema: schema,
    uiSchema: uiSchema,
    id: idSchema.$id,
    name: name,
    onChange: onChange,
    onFocus: onFocus,
    onBlur: onBlur,
    label: title === undefined ? name : title,
    value: formData,
    required: required,
    disabled: disabled,
    readonly: readonly,
    registry: registry,
    formContext: formContext,
    autofocus: autofocus,
    rawErrors: rawErrors
  });
}

var _excluded$7 = ["widget", "placeholder", "autofocus", "autocomplete", "title"];
/** The `AnyOfField` component is used to render a field in the schema that is an `anyOf`, `allOf` or `oneOf`. It tracks
 * the currently selected option and cleans up any irrelevant data in `formData`.
 *
 * @param props - The `FieldProps` for this template
 */
var AnyOfField = /*#__PURE__*/function (_Component) {
  _inheritsLoose(AnyOfField, _Component);
  /** Constructs an `AnyOfField` with the given `props` to initialize the initially selected option in state
   *
   * @param props - The `FieldProps` for this template
   */
  function AnyOfField(props) {
    var _this;
    _this = _Component.call(this, props) || this;
    _this.onOptionChange = function (option) {
      var _this$state = _this.state,
        selectedOption = _this$state.selectedOption,
        retrievedOptions = _this$state.retrievedOptions;
      var _this$props = _this.props,
        formData = _this$props.formData,
        onChange = _this$props.onChange,
        registry = _this$props.registry;
      var schemaUtils = registry.schemaUtils;
      var intOption = option !== undefined ? parseInt(option, 10) : -1;
      if (intOption === selectedOption) {
        return;
      }
      var newOption = intOption >= 0 ? retrievedOptions[intOption] : undefined;
      var oldOption = selectedOption >= 0 ? retrievedOptions[selectedOption] : undefined;
      var newFormData = schemaUtils.sanitizeDataForNewSchema(newOption, oldOption, formData);
      if (newFormData && newOption) {
        // Call getDefaultFormState to make sure defaults are populated on change. Pass "excludeObjectChildren"
        // so that only the root objects themselves are created without adding undefined children properties
        newFormData = schemaUtils.getDefaultFormState(newOption, newFormData, 'excludeObjectChildren');
      }
      onChange(newFormData, undefined, _this.getFieldId());
      _this.setState({
        selectedOption: intOption
      });
    };
    var _this$props2 = _this.props,
      _formData = _this$props2.formData,
      options = _this$props2.options,
      _schemaUtils = _this$props2.registry.schemaUtils;
    // cache the retrieved options in state in case they have $refs to save doing it later
    var _retrievedOptions = options.map(function (opt) {
      return _schemaUtils.retrieveSchema(opt, _formData);
    });
    _this.state = {
      retrievedOptions: _retrievedOptions,
      selectedOption: _this.getMatchingOption(0, _formData, _retrievedOptions)
    };
    return _this;
  }
  /** React lifecycle method that is called when the props and/or state for this component is updated. It recomputes the
   * currently selected option based on the overall `formData`
   *
   * @param prevProps - The previous `FieldProps` for this template
   * @param prevState - The previous `AnyOfFieldState` for this template
   */
  var _proto = AnyOfField.prototype;
  _proto.componentDidUpdate = function componentDidUpdate(prevProps, prevState) {
    var _this$props3 = this.props,
      formData = _this$props3.formData,
      options = _this$props3.options,
      idSchema = _this$props3.idSchema;
    var selectedOption = this.state.selectedOption;
    var newState = this.state;
    if (!deepEquals(prevProps.options, options)) {
      var schemaUtils = this.props.registry.schemaUtils;
      // re-cache the retrieved options in state in case they have $refs to save doing it later
      var retrievedOptions = options.map(function (opt) {
        return schemaUtils.retrieveSchema(opt, formData);
      });
      newState = {
        selectedOption: selectedOption,
        retrievedOptions: retrievedOptions
      };
    }
    if (!deepEquals(formData, prevProps.formData) && idSchema.$id === prevProps.idSchema.$id) {
      var _newState = newState,
        _retrievedOptions2 = _newState.retrievedOptions;
      var matchingOption = this.getMatchingOption(selectedOption, formData, _retrievedOptions2);
      if (prevState && matchingOption !== selectedOption) {
        newState = {
          selectedOption: matchingOption,
          retrievedOptions: _retrievedOptions2
        };
      }
    }
    if (newState !== this.state) {
      this.setState(newState);
    }
  }
  /** Determines the best matching option for the given `formData` and `options`.
   *
   * @param formData - The new formData
   * @param options - The list of options to choose from
   * @return - The index of the `option` that best matches the `formData`
   */;
  _proto.getMatchingOption = function getMatchingOption(selectedOption, formData, options) {
    var schemaUtils = this.props.registry.schemaUtils;
    var option = schemaUtils.getClosestMatchingOption(formData, options, selectedOption);
    if (option > 0) {
      return option;
    }
    // If the form data matches none of the options, use the currently selected
    // option, assuming it's available; otherwise use the first option
    return selectedOption || 0;
  }
  /** Callback handler to remember what the currently selected option is. In addition to that the `formData` is updated
   * to remove properties that are not part of the newly selected option schema, and then the updated data is passed to
   * the `onChange` handler.
   *
   * @param option - The new option value being selected
   */;
  _proto.getFieldId = function getFieldId() {
    var _this$props4 = this.props,
      idSchema = _this$props4.idSchema,
      schema = _this$props4.schema;
    return "" + idSchema.$id + (schema.oneOf ? '__oneof_select' : '__anyof_select');
  }
  /** Renders the `AnyOfField` selector along with a `SchemaField` for the value of the `formData`
   */;
  _proto.render = function render() {
    var _this$props5 = this.props,
      name = _this$props5.name,
      baseType = _this$props5.baseType,
      _this$props5$disabled = _this$props5.disabled,
      disabled = _this$props5$disabled === void 0 ? false : _this$props5$disabled,
      _this$props5$errorSch = _this$props5.errorSchema,
      errorSchema = _this$props5$errorSch === void 0 ? {} : _this$props5$errorSch,
      formContext = _this$props5.formContext,
      onBlur = _this$props5.onBlur,
      onFocus = _this$props5.onFocus,
      registry = _this$props5.registry,
      schema = _this$props5.schema,
      uiSchema = _this$props5.uiSchema;
    var widgets = registry.widgets,
      fields = registry.fields,
      translateString = registry.translateString;
    var _SchemaField = fields.SchemaField;
    var _this$state2 = this.state,
      selectedOption = _this$state2.selectedOption,
      retrievedOptions = _this$state2.retrievedOptions;
    var _getUiOptions = getUiOptions(uiSchema),
      _getUiOptions$widget = _getUiOptions.widget,
      widget = _getUiOptions$widget === void 0 ? 'select' : _getUiOptions$widget,
      placeholder = _getUiOptions.placeholder,
      autofocus = _getUiOptions.autofocus,
      autocomplete = _getUiOptions.autocomplete,
      _getUiOptions$title = _getUiOptions.title,
      title = _getUiOptions$title === void 0 ? schema.title : _getUiOptions$title,
      uiOptions = _objectWithoutPropertiesLoose(_getUiOptions, _excluded$7);
    var Widget = getWidget({
      type: 'number'
    }, widget, widgets);
    var rawErrors = get(errorSchema, ERRORS_KEY, []);
    var fieldErrorSchema = omit(errorSchema, [ERRORS_KEY]);
    var option = selectedOption >= 0 ? retrievedOptions[selectedOption] || null : null;
    var optionSchema;
    if (option) {
      // If the subschema doesn't declare a type, infer the type from the
      // parent schema
      optionSchema = option.type ? option : Object.assign({}, option, {
        type: baseType
      });
    }
    var translateEnum = title ? TranslatableString.TitleOptionPrefix : TranslatableString.OptionPrefix;
    var translateParams = title ? [title] : [];
    var enumOptions = retrievedOptions.map(function (opt, index) {
      return {
        label: opt.title || translateString(translateEnum, translateParams.concat(String(index + 1))),
        value: index
      };
    });
    return jsxs("div", {
      className: 'panel panel-default panel-body',
      children: [jsx("div", {
        className: 'form-group',
        children: jsx(Widget, {
          id: this.getFieldId(),
          name: "" + name + (schema.oneOf ? '__oneof_select' : '__anyof_select'),
          schema: {
            type: 'number',
            "default": 0
          },
          onChange: this.onOptionChange,
          onBlur: onBlur,
          onFocus: onFocus,
          disabled: disabled || isEmpty(enumOptions),
          multiple: false,
          rawErrors: rawErrors,
          errorSchema: fieldErrorSchema,
          value: selectedOption >= 0 ? selectedOption : undefined,
          options: _extends({
            enumOptions: enumOptions
          }, uiOptions),
          registry: registry,
          formContext: formContext,
          placeholder: placeholder,
          autocomplete: autocomplete,
          autofocus: autofocus,
          label: ''
        })
      }), option !== null && jsx(_SchemaField, _extends({}, this.props, {
        schema: optionSchema
      }))]
    });
  };
  return AnyOfField;
}(Component);

// Matches a string that ends in a . character, optionally followed by a sequence of
// digits followed by any number of 0 characters up until the end of the line.
// Ensuring that there is at least one prefixed character is important so that
// you don't incorrectly match against "0".
var trailingCharMatcherWithPrefix = /\.([0-9]*0)*$/;
// This is used for trimming the trailing 0 and . characters without affecting
// the rest of the string. Its possible to use one RegEx with groups for this
// functionality, but it is fairly complex compared to simply defining two
// different matchers.
var trailingCharMatcher = /[0.]0*$/;
/**
 * The NumberField class has some special handling for dealing with trailing
 * decimal points and/or zeroes. This logic is designed to allow trailing values
 * to be visible in the input element, but not be represented in the
 * corresponding form data.
 *
 * The algorithm is as follows:
 *
 * 1. When the input value changes the value is cached in the component state
 *
 * 2. The value is then normalized, removing trailing decimal points and zeros,
 *    then passed to the "onChange" callback
 *
 * 3. When the component is rendered, the formData value is checked against the
 *    value cached in the state. If it matches the cached value, the cached
 *    value is passed to the input instead of the formData value
 */
function NumberField(props) {
  var registry = props.registry,
    onChange = props.onChange,
    formData = props.formData,
    initialValue = props.value;
  var _useState = useState(initialValue),
    lastValue = _useState[0],
    setLastValue = _useState[1];
  var StringField = registry.fields.StringField;
  var value = formData;
  /** Handle the change from the `StringField` to properly convert to a number
   *
   * @param value - The current value for the change occurring
   */
  var handleChange = useCallback(function (value) {
    // Cache the original value in component state
    setLastValue(value);
    // Normalize decimals that don't start with a zero character in advance so
    // that the rest of the normalization logic is simpler
    if (("" + value).charAt(0) === '.') {
      value = "0" + value;
    }
    // Check that the value is a string (this can happen if the widget used is a
    // <select>, due to an enum declaration etc) then, if the value ends in a
    // trailing decimal point or multiple zeroes, strip the trailing values
    var processed = typeof value === 'string' && value.match(trailingCharMatcherWithPrefix) ? asNumber(value.replace(trailingCharMatcher, '')) : asNumber(value);
    onChange(processed);
  }, [onChange]);
  if (typeof lastValue === 'string' && typeof value === 'number') {
    // Construct a regular expression that checks for a string that consists
    // of the formData value suffixed with zero or one '.' characters and zero
    // or more '0' characters
    var re = new RegExp(("" + value).replace('.', '\\.') + '\\.?0*$');
    // If the cached "lastValue" is a match, use that instead of the formData
    // value to prevent the input value from changing in the UI
    if (lastValue.match(re)) {
      value = lastValue;
    }
  }
  return jsx(StringField, _extends({}, props, {
    formData: value,
    onChange: handleChange
  }));
}

/** The `ObjectField` component is used to render a field in the schema that is of type `object`. It tracks whether an
 * additional property key was modified and what it was modified to
 *
 * @param props - The `FieldProps` for this template
 */
var ObjectField = /*#__PURE__*/function (_Component) {
  _inheritsLoose(ObjectField, _Component);
  function ObjectField() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _Component.call.apply(_Component, [this].concat(args)) || this;
    _this.state = {
      wasPropertyKeyModified: false,
      additionalProperties: {}
    };
    _this.onPropertyChange = function (name, addedByAdditionalProperties) {
      if (addedByAdditionalProperties === void 0) {
        addedByAdditionalProperties = false;
      }
      return function (value, newErrorSchema, id) {
        var _extends2, _extends3;
        var _this$props = _this.props,
          formData = _this$props.formData,
          onChange = _this$props.onChange,
          errorSchema = _this$props.errorSchema;
        if (value === undefined && addedByAdditionalProperties) {
          // Don't set value = undefined for fields added by
          // additionalProperties. Doing so removes them from the
          // formData, which causes them to completely disappear
          // (including the input field for the property name). Unlike
          // fields which are "mandated" by the schema, these fields can
          // be set to undefined by clicking a "delete field" button, so
          // set empty values to the empty string.
          value = '';
        }
        var newFormData = _extends({}, formData, (_extends2 = {}, _extends2[name] = value, _extends2));
        onChange(newFormData, errorSchema && errorSchema && _extends({}, errorSchema, (_extends3 = {}, _extends3[name] = newErrorSchema, _extends3)), id);
      };
    };
    _this.onDropPropertyClick = function (key) {
      return function (event) {
        event.preventDefault();
        var _this$props2 = _this.props,
          onChange = _this$props2.onChange,
          formData = _this$props2.formData;
        var copiedFormData = _extends({}, formData);
        unset(copiedFormData, key);
        onChange(copiedFormData);
      };
    };
    _this.getAvailableKey = function (preferredKey, formData) {
      var uiSchema = _this.props.uiSchema;
      var _getUiOptions = getUiOptions(uiSchema),
        _getUiOptions$duplica = _getUiOptions.duplicateKeySuffixSeparator,
        duplicateKeySuffixSeparator = _getUiOptions$duplica === void 0 ? '-' : _getUiOptions$duplica;
      var index = 0;
      var newKey = preferredKey;
      while (has(formData, newKey)) {
        newKey = "" + preferredKey + duplicateKeySuffixSeparator + ++index;
      }
      return newKey;
    };
    _this.onKeyChange = function (oldValue) {
      return function (value, newErrorSchema) {
        var _newKeys, _extends4;
        if (oldValue === value) {
          return;
        }
        var _this$props3 = _this.props,
          formData = _this$props3.formData,
          onChange = _this$props3.onChange,
          errorSchema = _this$props3.errorSchema;
        value = _this.getAvailableKey(value, formData);
        var newFormData = _extends({}, formData);
        var newKeys = (_newKeys = {}, _newKeys[oldValue] = value, _newKeys);
        var keyValues = Object.keys(newFormData).map(function (key) {
          var _ref;
          var newKey = newKeys[key] || key;
          return _ref = {}, _ref[newKey] = newFormData[key], _ref;
        });
        var renamedObj = Object.assign.apply(Object, [{}].concat(keyValues));
        _this.setState({
          wasPropertyKeyModified: true
        });
        onChange(renamedObj, errorSchema && errorSchema && _extends({}, errorSchema, (_extends4 = {}, _extends4[value] = newErrorSchema, _extends4)));
      };
    };
    _this.handleAddClick = function (schema) {
      return function () {
        if (!schema.additionalProperties) {
          return;
        }
        var _this$props4 = _this.props,
          formData = _this$props4.formData,
          onChange = _this$props4.onChange,
          registry = _this$props4.registry;
        var newFormData = _extends({}, formData);
        var type = undefined;
        if (isObject(schema.additionalProperties)) {
          type = schema.additionalProperties.type;
          var apSchema = schema.additionalProperties;
          if (REF_KEY in apSchema) {
            var schemaUtils = registry.schemaUtils;
            apSchema = schemaUtils.retrieveSchema({
              $ref: apSchema[REF_KEY]
            }, formData);
            type = apSchema.type;
          }
          if (!type && (ANY_OF_KEY in apSchema || ONE_OF_KEY in apSchema)) {
            type = 'object';
          }
        }
        var newKey = _this.getAvailableKey('newKey', newFormData);
        // Cast this to make the `set` work properly
        set(newFormData, newKey, _this.getDefaultValue(type));
        onChange(newFormData);
      };
    };
    return _this;
  }
  var _proto = ObjectField.prototype;
  /** Returns a flag indicating whether the `name` field is required in the object schema
   *
   * @param name - The name of the field to check for required-ness
   * @returns - True if the field `name` is required, false otherwise
   */
  _proto.isRequired = function isRequired(name) {
    var schema = this.props.schema;
    return Array.isArray(schema.required) && schema.required.indexOf(name) !== -1;
  }
  /** Returns the `onPropertyChange` handler for the `name` field. Handles the special case where a user is attempting
   * to clear the data for a field added as an additional property. Calls the `onChange()` handler with the updated
   * formData.
   *
   * @param name - The name of the property
   * @param addedByAdditionalProperties - Flag indicating whether this property is an additional property
   * @returns - The onPropertyChange callback for the `name` property
   */;
  /** Returns a default value to be used for a new additional schema property of the given `type`
   *
   * @param type - The type of the new additional schema property
   */
  _proto.getDefaultValue = function getDefaultValue(type) {
    var translateString = this.props.registry.translateString;
    switch (type) {
      case 'array':
        return [];
      case 'boolean':
        return false;
      case 'null':
        return null;
      case 'number':
        return 0;
      case 'object':
        return {};
      case 'string':
      default:
        // We don't have a datatype for some reason (perhaps additionalProperties was true)
        return translateString(TranslatableString.NewStringDefault);
    }
  }
  /** Handles the adding of a new additional property on the given `schema`. Calls the `onChange` callback once the new
   * default data for that field has been added to the formData.
   *
   * @param schema - The schema element to which the new property is being added
   */;
  /** Renders the `ObjectField` from the given props
   */
  _proto.render = function render() {
    var _this2 = this;
    var _this$props5 = this.props,
      rawSchema = _this$props5.schema,
      _this$props5$uiSchema = _this$props5.uiSchema,
      uiSchema = _this$props5$uiSchema === void 0 ? {} : _this$props5$uiSchema,
      formData = _this$props5.formData,
      errorSchema = _this$props5.errorSchema,
      idSchema = _this$props5.idSchema,
      name = _this$props5.name,
      _this$props5$required = _this$props5.required,
      required = _this$props5$required === void 0 ? false : _this$props5$required,
      _this$props5$disabled = _this$props5.disabled,
      disabled = _this$props5$disabled === void 0 ? false : _this$props5$disabled,
      _this$props5$readonly = _this$props5.readonly,
      readonly = _this$props5$readonly === void 0 ? false : _this$props5$readonly,
      hideError = _this$props5.hideError,
      idPrefix = _this$props5.idPrefix,
      idSeparator = _this$props5.idSeparator,
      onBlur = _this$props5.onBlur,
      onFocus = _this$props5.onFocus,
      registry = _this$props5.registry;
    var fields = registry.fields,
      formContext = registry.formContext,
      schemaUtils = registry.schemaUtils;
    var SchemaField = fields.SchemaField;
    var schema = schemaUtils.retrieveSchema(rawSchema, formData);
    var uiOptions = getUiOptions(uiSchema);
    var _schema$properties = schema.properties,
      schemaProperties = _schema$properties === void 0 ? {} : _schema$properties;
    var title = schema.title === undefined ? name : schema.title;
    var description = uiOptions.description || schema.description;
    var orderedProperties;
    try {
      var properties = Object.keys(schemaProperties);
      orderedProperties = orderProperties(properties, uiOptions.order);
    } catch (err) {
      return jsxs("div", {
        children: [jsxs("p", {
          className: 'config-error',
          style: {
            color: 'red'
          },
          children: ["Invalid ", name || 'root', " object field configuration:", jsx("em", {
            children: err.message
          }), "."]
        }), jsx("pre", {
          children: JSON.stringify(schema)
        })]
      });
    }
    var Template = getTemplate('ObjectFieldTemplate', registry, uiOptions);
    var templateProps = {
      title: uiOptions.title || title,
      description: description,
      properties: orderedProperties.map(function (name) {
        var addedByAdditionalProperties = has(schema, [PROPERTIES_KEY, name, ADDITIONAL_PROPERTY_FLAG]);
        var fieldUiSchema = addedByAdditionalProperties ? uiSchema.additionalProperties : uiSchema[name];
        var hidden = getUiOptions(fieldUiSchema).widget === 'hidden';
        var fieldIdSchema = get(idSchema, [name], {});
        return {
          content: jsx(SchemaField, {
            name: name,
            required: _this2.isRequired(name),
            schema: get(schema, [PROPERTIES_KEY, name], {}),
            uiSchema: fieldUiSchema,
            errorSchema: get(errorSchema, name),
            idSchema: fieldIdSchema,
            idPrefix: idPrefix,
            idSeparator: idSeparator,
            formData: get(formData, name),
            formContext: formContext,
            wasPropertyKeyModified: _this2.state.wasPropertyKeyModified,
            onKeyChange: _this2.onKeyChange(name),
            onChange: _this2.onPropertyChange(name, addedByAdditionalProperties),
            onBlur: onBlur,
            onFocus: onFocus,
            registry: registry,
            disabled: disabled,
            readonly: readonly,
            hideError: hideError,
            onDropPropertyClick: _this2.onDropPropertyClick
          }, name),
          name: name,
          readonly: readonly,
          disabled: disabled,
          required: required,
          hidden: hidden
        };
      }),
      readonly: readonly,
      disabled: disabled,
      required: required,
      idSchema: idSchema,
      uiSchema: uiSchema,
      schema: schema,
      formData: formData,
      formContext: formContext,
      registry: registry
    };
    return jsx(Template, _extends({}, templateProps, {
      onAddClick: this.handleAddClick
    }));
  };
  return ObjectField;
}(Component);

var _excluded$6 = ["__errors"];
/** The map of component type to FieldName */
var COMPONENT_TYPES = {
  array: 'ArrayField',
  "boolean": 'BooleanField',
  integer: 'NumberField',
  number: 'NumberField',
  object: 'ObjectField',
  string: 'StringField',
  "null": 'NullField'
};
/** Computes and returns which `Field` implementation to return in order to render the field represented by the
 * `schema`. The `uiOptions` are used to alter what potential `Field` implementation is actually returned. If no
 * appropriate `Field` implementation can be found then a wrapper around `UnsupportedFieldTemplate` is used.
 *
 * @param schema - The schema from which to obtain the type
 * @param uiOptions - The UI Options that may affect the component decision
 * @param idSchema - The id that is passed to the `UnsupportedFieldTemplate`
 * @param registry - The registry from which fields and templates are obtained
 * @returns - The `Field` component that is used to render the actual field data
 */
function getFieldComponent(schema, uiOptions, idSchema, registry) {
  var field = uiOptions.field;
  var fields = registry.fields,
    translateString = registry.translateString;
  if (typeof field === 'function') {
    return field;
  }
  if (typeof field === 'string' && field in fields) {
    return fields[field];
  }
  var schemaType = getSchemaType(schema);
  var type = Array.isArray(schemaType) ? schemaType[0] : schemaType || '';
  var componentName = COMPONENT_TYPES[type];
  // If the type is not defined and the schema uses 'anyOf' or 'oneOf', don't
  // render a field and let the MultiSchemaField component handle the form display
  if (!componentName && (schema.anyOf || schema.oneOf)) {
    return function () {
      return null;
    };
  }
  return componentName in fields ? fields[componentName] : function () {
    var UnsupportedFieldTemplate = getTemplate('UnsupportedFieldTemplate', registry, uiOptions);
    return jsx(UnsupportedFieldTemplate, {
      schema: schema,
      idSchema: idSchema,
      reason: translateString(TranslatableString.UnknownFieldType, [String(schema.type)]),
      registry: registry
    });
  };
}
/** The `SchemaFieldRender` component is the work-horse of react-jsonschema-form, determining what kind of real field to
 * render based on the `schema`, `uiSchema` and all the other props. It also deals with rendering the `anyOf` and
 * `oneOf` fields.
 *
 * @param props - The `FieldProps` for this component
 */
function SchemaFieldRender(props) {
  var _schema = props.schema,
    _idSchema = props.idSchema,
    uiSchema = props.uiSchema,
    formData = props.formData,
    errorSchema = props.errorSchema,
    idPrefix = props.idPrefix,
    idSeparator = props.idSeparator,
    name = props.name,
    onChange = props.onChange,
    onKeyChange = props.onKeyChange,
    onDropPropertyClick = props.onDropPropertyClick,
    required = props.required,
    registry = props.registry,
    _props$wasPropertyKey = props.wasPropertyKeyModified,
    wasPropertyKeyModified = _props$wasPropertyKey === void 0 ? false : _props$wasPropertyKey;
  var formContext = registry.formContext,
    schemaUtils = registry.schemaUtils;
  var uiOptions = getUiOptions(uiSchema);
  var FieldTemplate = getTemplate('FieldTemplate', registry, uiOptions);
  var DescriptionFieldTemplate = getTemplate('DescriptionFieldTemplate', registry, uiOptions);
  var FieldHelpTemplate = getTemplate('FieldHelpTemplate', registry, uiOptions);
  var FieldErrorTemplate = getTemplate('FieldErrorTemplate', registry, uiOptions);
  var schema = schemaUtils.retrieveSchema(_schema, formData);
  var fieldId = _idSchema[ID_KEY];
  var idSchema = mergeObjects(schemaUtils.toIdSchema(schema, fieldId, formData, idPrefix, idSeparator), _idSchema);
  /** Intermediary `onChange` handler for field components that will inject the `id` of the current field into the
   * `onChange` chain if it is not already being provided from a deeper level in the hierarchy
   */
  var handleFieldComponentChange = useCallback(function (formData, newErrorSchema, id) {
    var theId = id || fieldId;
    return onChange(formData, newErrorSchema, theId);
  }, [fieldId, onChange]);
  var FieldComponent = getFieldComponent(schema, uiOptions, idSchema, registry);
  var disabled = Boolean(props.disabled || uiOptions.disabled);
  var readonly = Boolean(props.readonly || uiOptions.readonly || props.schema.readOnly || schema.readOnly);
  var uiSchemaHideError = uiOptions.hideError;
  // Set hideError to the value provided in the uiSchema, otherwise stick with the prop to propagate to children
  var hideError = uiSchemaHideError === undefined ? props.hideError : Boolean(uiSchemaHideError);
  var autofocus = Boolean(props.autofocus || uiOptions.autofocus);
  if (Object.keys(schema).length === 0) {
    return null;
  }
  var displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema);
  var _ref = errorSchema || {},
    __errors = _ref.__errors,
    fieldErrorSchema = _objectWithoutPropertiesLoose(_ref, _excluded$6);
  // See #439: uiSchema: Don't pass consumed class names or style to child components
  var fieldUiSchema = omit(uiSchema, ['ui:classNames', 'classNames', 'ui:style']);
  if (UI_OPTIONS_KEY in fieldUiSchema) {
    fieldUiSchema[UI_OPTIONS_KEY] = omit(fieldUiSchema[UI_OPTIONS_KEY], ['classNames', 'style']);
  }
  var field = jsx(FieldComponent, _extends({}, props, {
    onChange: handleFieldComponentChange,
    idSchema: idSchema,
    schema: schema,
    uiSchema: fieldUiSchema,
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    autofocus: autofocus,
    errorSchema: fieldErrorSchema,
    formContext: formContext,
    rawErrors: __errors
  }));
  var id = idSchema[ID_KEY];
  // If this schema has a title defined, but the user has set a new key/label, retain their input.
  var label;
  if (wasPropertyKeyModified) {
    label = name;
  } else {
    label = ADDITIONAL_PROPERTY_FLAG in schema ? name : uiOptions.title || props.schema.title || schema.title || name;
  }
  var description = uiOptions.description || props.schema.description || schema.description || '';
  var help = uiOptions.help;
  var hidden = uiOptions.widget === 'hidden';
  var classNames = ['form-group', 'field', "field-" + schema.type];
  if (!hideError && __errors && __errors.length > 0) {
    classNames.push('field-error has-error has-danger');
  }
  if (uiSchema !== null && uiSchema !== void 0 && uiSchema.classNames) {
    if (process.env.NODE_ENV !== 'production') {
      console.warn("'uiSchema.classNames' is deprecated and may be removed in a major release; Use 'ui:classNames' instead.");
    }
    classNames.push(uiSchema.classNames);
  }
  if (uiOptions.classNames) {
    classNames.push(uiOptions.classNames);
  }
  var helpComponent = jsx(FieldHelpTemplate, {
    help: help,
    idSchema: idSchema,
    schema: schema,
    uiSchema: uiSchema,
    hasErrors: !hideError && __errors && __errors.length > 0,
    registry: registry
  });
  var errorsComponent = hideError ? undefined : jsx(FieldErrorTemplate, {
    errors: __errors,
    errorSchema: errorSchema,
    idSchema: idSchema,
    schema: schema,
    uiSchema: uiSchema,
    registry: registry
  });
  var fieldProps = {
    description: jsx(DescriptionFieldTemplate, {
      id: descriptionId(id),
      description: description,
      schema: schema,
      uiSchema: uiSchema,
      registry: registry
    }),
    rawDescription: description,
    help: helpComponent,
    rawHelp: typeof help === 'string' ? help : undefined,
    errors: errorsComponent,
    rawErrors: hideError ? undefined : __errors,
    id: id,
    label: label,
    hidden: hidden,
    onChange: onChange,
    onKeyChange: onKeyChange,
    onDropPropertyClick: onDropPropertyClick,
    required: required,
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    displayLabel: displayLabel,
    classNames: classNames.join(' ').trim(),
    style: uiOptions.style,
    formContext: formContext,
    formData: formData,
    schema: schema,
    uiSchema: uiSchema,
    registry: registry
  };
  var _AnyOfField = registry.fields.AnyOfField;
  var _OneOfField = registry.fields.OneOfField;
  var isReplacingAnyOrOneOf = (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema['ui:field']) && (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema['ui:fieldReplacesAnyOrOneOf']) === true;
  return jsx(FieldTemplate, _extends({}, fieldProps, {
    children: jsxs(Fragment, {
      children: [field, schema.anyOf && !isReplacingAnyOrOneOf && !schemaUtils.isSelect(schema) && jsx(_AnyOfField, {
        name: name,
        disabled: disabled,
        readonly: readonly,
        hideError: hideError,
        errorSchema: errorSchema,
        formData: formData,
        formContext: formContext,
        idPrefix: idPrefix,
        idSchema: idSchema,
        idSeparator: idSeparator,
        onBlur: props.onBlur,
        onChange: props.onChange,
        onFocus: props.onFocus,
        options: schema.anyOf.map(function (_schema) {
          return schemaUtils.retrieveSchema(isObject(_schema) ? _schema : {}, formData);
        }),
        baseType: schema.type,
        registry: registry,
        schema: schema,
        uiSchema: uiSchema
      }), schema.oneOf && !isReplacingAnyOrOneOf && !schemaUtils.isSelect(schema) && jsx(_OneOfField, {
        name: name,
        disabled: disabled,
        readonly: readonly,
        hideError: hideError,
        errorSchema: errorSchema,
        formData: formData,
        formContext: formContext,
        idPrefix: idPrefix,
        idSchema: idSchema,
        idSeparator: idSeparator,
        onBlur: props.onBlur,
        onChange: props.onChange,
        onFocus: props.onFocus,
        options: schema.oneOf.map(function (_schema) {
          return schemaUtils.retrieveSchema(isObject(_schema) ? _schema : {}, formData);
        }),
        baseType: schema.type,
        registry: registry,
        schema: schema,
        uiSchema: uiSchema
      })]
    })
  }));
}
/** The `SchemaField` component determines whether it is necessary to rerender the component based on any props changes
 * and if so, calls the `SchemaFieldRender` component with the props.
 */
var SchemaField = /*#__PURE__*/function (_Component) {
  _inheritsLoose(SchemaField, _Component);
  function SchemaField() {
    return _Component.apply(this, arguments) || this;
  }
  var _proto = SchemaField.prototype;
  _proto.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
    return !deepEquals(this.props, nextProps);
  };
  _proto.render = function render() {
    return jsx(SchemaFieldRender, _extends({}, this.props));
  };
  return SchemaField;
}(Component);

var _excluded$5 = ["widget", "placeholder"];
/** The `StringField` component is used to render a schema field that represents a string type
 *
 * @param props - The `FieldProps` for this template
 */
function StringField(props) {
  var schema = props.schema,
    name = props.name,
    uiSchema = props.uiSchema,
    idSchema = props.idSchema,
    formData = props.formData,
    required = props.required,
    _props$disabled = props.disabled,
    disabled = _props$disabled === void 0 ? false : _props$disabled,
    _props$readonly = props.readonly,
    readonly = _props$readonly === void 0 ? false : _props$readonly,
    _props$autofocus = props.autofocus,
    autofocus = _props$autofocus === void 0 ? false : _props$autofocus,
    onChange = props.onChange,
    onBlur = props.onBlur,
    onFocus = props.onFocus,
    registry = props.registry,
    rawErrors = props.rawErrors;
  var title = schema.title,
    format = schema.format;
  var widgets = registry.widgets,
    formContext = registry.formContext,
    schemaUtils = registry.schemaUtils;
  var enumOptions = schemaUtils.isSelect(schema) ? optionsList(schema) : undefined;
  var defaultWidget = enumOptions ? 'select' : 'text';
  if (format && hasWidget(schema, format, widgets)) {
    defaultWidget = format;
  }
  var _getUiOptions = getUiOptions(uiSchema),
    _getUiOptions$widget = _getUiOptions.widget,
    widget = _getUiOptions$widget === void 0 ? defaultWidget : _getUiOptions$widget,
    _getUiOptions$placeho = _getUiOptions.placeholder,
    placeholder = _getUiOptions$placeho === void 0 ? '' : _getUiOptions$placeho,
    options = _objectWithoutPropertiesLoose(_getUiOptions, _excluded$5);
  var Widget = getWidget(schema, widget, widgets);
  return jsx(Widget, {
    options: _extends({}, options, {
      enumOptions: enumOptions
    }),
    schema: schema,
    uiSchema: uiSchema,
    id: idSchema.$id,
    name: name,
    label: title === undefined ? name : title,
    value: formData,
    onChange: onChange,
    onBlur: onBlur,
    onFocus: onFocus,
    required: required,
    disabled: disabled,
    readonly: readonly,
    formContext: formContext,
    autofocus: autofocus,
    registry: registry,
    placeholder: placeholder,
    rawErrors: rawErrors
  });
}

/** The `NullField` component is used to render a field in the schema is null. It also ensures that the `formData` is
 * also set to null if it has no value.
 *
 * @param props - The `FieldProps` for this template
 */
function NullField(props) {
  var formData = props.formData,
    onChange = props.onChange;
  useEffect(function () {
    if (formData === undefined) {
      onChange(null);
    }
  }, [formData, onChange]);
  return null;
}

function fields() {
  return {
    AnyOfField: AnyOfField,
    ArrayField: ArrayField,
    // ArrayField falls back to SchemaField if ArraySchemaField is not defined, which it isn't by default
    BooleanField: BooleanField,
    NumberField: NumberField,
    ObjectField: ObjectField,
    OneOfField: AnyOfField,
    SchemaField: SchemaField,
    StringField: StringField,
    NullField: NullField
  };
}

/** The `ArrayFieldDescriptionTemplate` component renders a `DescriptionFieldTemplate` with an `id` derived from
 * the `idSchema`.
 *
 * @param props - The `ArrayFieldDescriptionProps` for the component
 */
function ArrayFieldDescriptionTemplate(props) {
  var idSchema = props.idSchema,
    description = props.description,
    registry = props.registry,
    schema = props.schema,
    uiSchema = props.uiSchema;
  var options = getUiOptions(uiSchema);
  var _options$label = options.label,
    displayLabel = _options$label === void 0 ? true : _options$label;
  if (!description || !displayLabel) {
    return null;
  }
  var DescriptionFieldTemplate = getTemplate('DescriptionFieldTemplate', registry, options);
  return jsx(DescriptionFieldTemplate, {
    id: descriptionId(idSchema),
    description: description,
    schema: schema,
    uiSchema: uiSchema,
    registry: registry
  });
}

/** The `ArrayFieldItemTemplate` component is the template used to render an items of an array.
 *
 * @param props - The `ArrayFieldTemplateItemType` props for the component
 */
function ArrayFieldItemTemplate(props) {
  var children = props.children,
    className = props.className,
    disabled = props.disabled,
    hasToolbar = props.hasToolbar,
    hasMoveDown = props.hasMoveDown,
    hasMoveUp = props.hasMoveUp,
    hasRemove = props.hasRemove,
    index = props.index,
    onDropIndexClick = props.onDropIndexClick,
    onReorderClick = props.onReorderClick,
    readonly = props.readonly,
    registry = props.registry,
    uiSchema = props.uiSchema;
  var _registry$templates$B = registry.templates.ButtonTemplates,
    MoveDownButton = _registry$templates$B.MoveDownButton,
    MoveUpButton = _registry$templates$B.MoveUpButton,
    RemoveButton = _registry$templates$B.RemoveButton;
  var btnStyle = {
    flex: 1,
    paddingLeft: 6,
    paddingRight: 6,
    fontWeight: 'bold'
  };
  return jsxs("div", {
    className: className,
    children: [jsx("div", {
      className: hasToolbar ? 'col-xs-9' : 'col-xs-12',
      children: children
    }), hasToolbar && jsx("div", {
      className: 'col-xs-3 array-item-toolbox',
      children: jsxs("div", {
        className: 'btn-group',
        style: {
          display: 'flex',
          justifyContent: 'space-around'
        },
        children: [(hasMoveUp || hasMoveDown) && jsx(MoveUpButton, {
          style: btnStyle,
          disabled: disabled || readonly || !hasMoveUp,
          onClick: onReorderClick(index, index - 1),
          uiSchema: uiSchema,
          registry: registry
        }), (hasMoveUp || hasMoveDown) && jsx(MoveDownButton, {
          style: btnStyle,
          disabled: disabled || readonly || !hasMoveDown,
          onClick: onReorderClick(index, index + 1),
          uiSchema: uiSchema,
          registry: registry
        }), hasRemove && jsx(RemoveButton, {
          style: btnStyle,
          disabled: disabled || readonly,
          onClick: onDropIndexClick(index),
          uiSchema: uiSchema,
          registry: registry
        })]
      })
    })]
  });
}

var _excluded$4 = ["key"];
/** The `ArrayFieldTemplate` component is the template used to render all items in an array.
 *
 * @param props - The `ArrayFieldTemplateItemType` props for the component
 */
function ArrayFieldTemplate(props) {
  var canAdd = props.canAdd,
    className = props.className,
    disabled = props.disabled,
    idSchema = props.idSchema,
    uiSchema = props.uiSchema,
    items = props.items,
    onAddClick = props.onAddClick,
    readonly = props.readonly,
    registry = props.registry,
    required = props.required,
    schema = props.schema,
    title = props.title;
  var uiOptions = getUiOptions(uiSchema);
  var ArrayFieldDescriptionTemplate = getTemplate('ArrayFieldDescriptionTemplate', registry, uiOptions);
  var ArrayFieldItemTemplate = getTemplate('ArrayFieldItemTemplate', registry, uiOptions);
  var ArrayFieldTitleTemplate = getTemplate('ArrayFieldTitleTemplate', registry, uiOptions);
  // Button templates are not overridden in the uiSchema
  var AddButton = registry.templates.ButtonTemplates.AddButton;
  return jsxs("fieldset", {
    className: className,
    id: idSchema.$id,
    children: [jsx(ArrayFieldTitleTemplate, {
      idSchema: idSchema,
      title: uiOptions.title || title,
      required: required,
      schema: schema,
      uiSchema: uiSchema,
      registry: registry
    }), jsx(ArrayFieldDescriptionTemplate, {
      idSchema: idSchema,
      description: uiOptions.description || schema.description,
      schema: schema,
      uiSchema: uiSchema,
      registry: registry
    }), jsx("div", {
      className: 'row array-item-list',
      children: items && items.map(function (_ref) {
        var key = _ref.key,
          itemProps = _objectWithoutPropertiesLoose(_ref, _excluded$4);
        return jsx(ArrayFieldItemTemplate, _extends({}, itemProps), key);
      })
    }), canAdd && jsx(AddButton, {
      className: 'array-item-add',
      onClick: onAddClick,
      disabled: disabled || readonly,
      uiSchema: uiSchema,
      registry: registry
    })]
  });
}

/** The `ArrayFieldTitleTemplate` component renders a `TitleFieldTemplate` with an `id` derived from
 * the `idSchema`.
 *
 * @param props - The `ArrayFieldTitleProps` for the component
 */
function ArrayFieldTitleTemplate(props) {
  var idSchema = props.idSchema,
    title = props.title,
    schema = props.schema,
    uiSchema = props.uiSchema,
    required = props.required,
    registry = props.registry;
  var options = getUiOptions(uiSchema);
  var _options$label = options.label,
    displayLabel = _options$label === void 0 ? true : _options$label;
  if (!title || !displayLabel) {
    return null;
  }
  var TitleFieldTemplate = getTemplate('TitleFieldTemplate', registry, options);
  return jsx(TitleFieldTemplate, {
    id: titleId(idSchema),
    title: title,
    required: required,
    schema: schema,
    uiSchema: uiSchema,
    registry: registry
  });
}

var _excluded$3 = ["id", "name", "value", "readonly", "disabled", "autofocus", "onBlur", "onFocus", "onChange", "onChangeOverride", "options", "schema", "uiSchema", "formContext", "registry", "rawErrors", "type"];
/** The `BaseInputTemplate` is the template to use to render the basic `<input>` component for the `core` theme.
 * It is used as the template for rendering many of the <input> based widgets that differ by `type` and callbacks only.
 * It can be customized/overridden for other themes or individual implementations as needed.
 *
 * @param props - The `WidgetProps` for this template
 */
function BaseInputTemplate(props) {
  var id = props.id,
    value = props.value,
    readonly = props.readonly,
    disabled = props.disabled,
    autofocus = props.autofocus,
    onBlur = props.onBlur,
    onFocus = props.onFocus,
    onChange = props.onChange,
    onChangeOverride = props.onChangeOverride,
    options = props.options,
    schema = props.schema,
    type = props.type,
    rest = _objectWithoutPropertiesLoose(props, _excluded$3);
  // Note: since React 15.2.0 we can't forward unknown element attributes, so we
  // exclude the "options" and "schema" ones here.
  if (!id) {
    console.log('No id for', props);
    throw new Error("no id for props " + JSON.stringify(props));
  }
  var inputProps = _extends({}, rest, getInputProps(schema, type, options));
  var inputValue;
  if (inputProps.type === 'number' || inputProps.type === 'integer') {
    inputValue = value || value === 0 ? value : '';
  } else {
    inputValue = value == null ? '' : value;
  }
  var _onChange = useCallback(function (_ref) {
    var value = _ref.target.value;
    return onChange(value === '' ? options.emptyValue : value);
  }, [onChange, options]);
  var _onBlur = useCallback(function (_ref2) {
    var value = _ref2.target.value;
    return onBlur(id, value);
  }, [onBlur, id]);
  var _onFocus = useCallback(function (_ref3) {
    var value = _ref3.target.value;
    return onFocus(id, value);
  }, [onFocus, id]);
  return jsxs(Fragment, {
    children: [jsx("input", _extends({
      id: id,
      name: id,
      className: 'form-control',
      readOnly: readonly,
      disabled: disabled,
      autoFocus: autofocus,
      value: inputValue
    }, inputProps, {
      list: schema.examples ? examplesId(id) : undefined,
      onChange: onChangeOverride || _onChange,
      onBlur: _onBlur,
      onFocus: _onFocus,
      "aria-describedby": ariaDescribedByIds(id, !!schema.examples)
    })), Array.isArray(schema.examples) && jsx("datalist", {
      id: examplesId(id),
      children: schema.examples.concat(schema["default"] && !schema.examples.includes(schema["default"]) ? [schema["default"]] : []).map(function (example) {
        return jsx("option", {
          value: example
        }, example);
      })
    }, "datalist_" + id)]
  });
}

/** The `SubmitButton` renders a button that represent the `Submit` action on a form
 */
function SubmitButton(_ref) {
  var uiSchema = _ref.uiSchema;
  var _getSubmitButtonOptio = getSubmitButtonOptions(uiSchema),
    submitText = _getSubmitButtonOptio.submitText,
    norender = _getSubmitButtonOptio.norender,
    _getSubmitButtonOptio2 = _getSubmitButtonOptio.props,
    submitButtonProps = _getSubmitButtonOptio2 === void 0 ? {} : _getSubmitButtonOptio2;
  if (norender) {
    return null;
  }
  return jsx("div", {
    children: jsx("button", _extends({
      type: 'submit'
    }, submitButtonProps, {
      className: "btn btn-info " + submitButtonProps.className,
      children: submitText
    }))
  });
}

var _excluded$2 = ["iconType", "icon", "className", "uiSchema", "registry"];
function IconButton(props) {
  var _props$iconType = props.iconType,
    iconType = _props$iconType === void 0 ? 'default' : _props$iconType,
    icon = props.icon,
    className = props.className,
    otherProps = _objectWithoutPropertiesLoose(props, _excluded$2);
  return jsx("button", _extends({
    type: 'button',
    className: "btn btn-" + iconType + " " + className
  }, otherProps, {
    children: jsx("i", {
      className: "glyphicon glyphicon-" + icon
    })
  }));
}
function MoveDownButton(props) {
  var translateString = props.registry.translateString;
  return jsx(IconButton, _extends({
    title: translateString(TranslatableString.MoveDownButton),
    className: 'array-item-move-down'
  }, props, {
    icon: 'arrow-down'
  }));
}
function MoveUpButton(props) {
  var translateString = props.registry.translateString;
  return jsx(IconButton, _extends({
    title: translateString(TranslatableString.MoveUpButton),
    className: 'array-item-move-up'
  }, props, {
    icon: 'arrow-up'
  }));
}
function RemoveButton(props) {
  var translateString = props.registry.translateString;
  return jsx(IconButton, _extends({
    title: translateString(TranslatableString.RemoveButton),
    className: 'array-item-remove'
  }, props, {
    iconType: 'danger',
    icon: 'remove'
  }));
}

/** The `AddButton` renders a button that represent the `Add` action on a form
 */
function AddButton(_ref) {
  var className = _ref.className,
    onClick = _ref.onClick,
    disabled = _ref.disabled,
    registry = _ref.registry;
  var translateString = registry.translateString;
  return jsx("div", {
    className: 'row',
    children: jsx("p", {
      className: "col-xs-3 col-xs-offset-9 text-right " + className,
      children: jsx(IconButton, {
        iconType: 'info',
        icon: 'plus',
        className: 'btn-add col-xs-12',
        title: translateString(TranslatableString.AddButton),
        onClick: onClick,
        disabled: disabled,
        registry: registry
      })
    })
  });
}

function buttonTemplates() {
  return {
    SubmitButton: SubmitButton,
    AddButton: AddButton,
    MoveDownButton: MoveDownButton,
    MoveUpButton: MoveUpButton,
    RemoveButton: RemoveButton
  };
}

/** The `DescriptionField` is the template to use to render the description of a field
 *
 * @param props - The `DescriptionFieldProps` for this component
 */
function DescriptionField(props) {
  var id = props.id,
    description = props.description;
  if (!description) {
    return null;
  }
  if (typeof description === 'string') {
    return jsx("p", {
      id: id,
      className: 'field-description',
      children: description
    });
  } else {
    return jsx("div", {
      id: id,
      className: 'field-description',
      children: description
    });
  }
}

/** The `ErrorList` component is the template that renders the all the errors associated with the fields in the `Form`
 *
 * @param props - The `ErrorListProps` for this component
 */
function ErrorList(_ref) {
  var errors = _ref.errors,
    registry = _ref.registry;
  var translateString = registry.translateString;
  return jsxs("div", {
    className: 'panel panel-danger errors',
    children: [jsx("div", {
      className: 'panel-heading',
      children: jsx("h3", {
        className: 'panel-title',
        children: translateString(TranslatableString.ErrorsLabel)
      })
    }), jsx("ul", {
      className: 'list-group',
      children: errors.map(function (error, i) {
        return jsx("li", {
          className: 'list-group-item text-danger',
          children: error.stack
        }, i);
      })
    })]
  });
}

var REQUIRED_FIELD_SYMBOL$1 = '*';
/** Renders a label for a field
 *
 * @param props - The `LabelProps` for this component
 */
function Label(props) {
  var label = props.label,
    required = props.required,
    id = props.id;
  if (!label) {
    return null;
  }
  return jsxs("label", {
    className: 'control-label',
    htmlFor: id,
    children: [label, required && jsx("span", {
      className: 'required',
      children: REQUIRED_FIELD_SYMBOL$1
    })]
  });
}

/** The `FieldTemplate` component is the template used by `SchemaField` to render any field. It renders the field
 * content, (label, description, children, errors and help) inside of a `WrapIfAdditional` component.
 *
 * @param props - The `FieldTemplateProps` for this component
 */
function FieldTemplate(props) {
  var id = props.id,
    label = props.label,
    children = props.children,
    errors = props.errors,
    help = props.help,
    description = props.description,
    hidden = props.hidden,
    required = props.required,
    displayLabel = props.displayLabel,
    registry = props.registry,
    uiSchema = props.uiSchema;
  var uiOptions = getUiOptions(uiSchema);
  var WrapIfAdditionalTemplate = getTemplate('WrapIfAdditionalTemplate', registry, uiOptions);
  if (hidden) {
    return jsx("div", {
      className: 'hidden',
      children: children
    });
  }
  return jsxs(WrapIfAdditionalTemplate, _extends({}, props, {
    children: [displayLabel && jsx(Label, {
      label: label,
      required: required,
      id: id
    }), displayLabel && description ? description : null, children, errors, help]
  }));
}

/** The `FieldErrorTemplate` component renders the errors local to the particular field
 *
 * @param props - The `FieldErrorProps` for the errors being rendered
 */
function FieldErrorTemplate(props) {
  var _props$errors = props.errors,
    errors = _props$errors === void 0 ? [] : _props$errors,
    idSchema = props.idSchema;
  if (errors.length === 0) {
    return null;
  }
  var id = errorId(idSchema);
  return jsx("div", {
    children: jsx("ul", {
      id: id,
      className: 'error-detail bs-callout bs-callout-info',
      children: errors.filter(function (elem) {
        return !!elem;
      }).map(function (error, index) {
        return jsx("li", {
          className: 'text-danger',
          children: error
        }, index);
      })
    })
  });
}

/** The `FieldHelpTemplate` component renders any help desired for a field
 *
 * @param props - The `FieldHelpProps` to be rendered
 */
function FieldHelpTemplate(props) {
  var idSchema = props.idSchema,
    help = props.help;
  if (!help) {
    return null;
  }
  var id = helpId(idSchema);
  if (typeof help === 'string') {
    return jsx("p", {
      id: id,
      className: 'help-block',
      children: help
    });
  }
  return jsx("div", {
    id: id,
    className: 'help-block',
    children: help
  });
}

/** The `ObjectFieldTemplate` is the template to use to render all the inner properties of an object along with the
 * title and description if available. If the object is expandable, then an `AddButton` is also rendered after all
 * the properties.
 *
 * @param props - The `ObjectFieldTemplateProps` for this component
 */
function ObjectFieldTemplate(props) {
  var description = props.description,
    disabled = props.disabled,
    formData = props.formData,
    idSchema = props.idSchema,
    onAddClick = props.onAddClick,
    properties = props.properties,
    readonly = props.readonly,
    registry = props.registry,
    required = props.required,
    schema = props.schema,
    title = props.title,
    uiSchema = props.uiSchema;
  var options = getUiOptions(uiSchema);
  var TitleFieldTemplate = getTemplate('TitleFieldTemplate', registry, options);
  var DescriptionFieldTemplate = getTemplate('DescriptionFieldTemplate', registry, options);
  // Button templates are not overridden in the uiSchema
  var AddButton = registry.templates.ButtonTemplates.AddButton;
  return jsxs("fieldset", {
    id: idSchema.$id,
    children: [(options.title || title) && jsx(TitleFieldTemplate, {
      id: titleId(idSchema),
      title: options.title || title,
      required: required,
      schema: schema,
      uiSchema: uiSchema,
      registry: registry
    }), (options.description || description) && jsx(DescriptionFieldTemplate, {
      id: descriptionId(idSchema),
      description: options.description || description,
      schema: schema,
      uiSchema: uiSchema,
      registry: registry
    }), properties.map(function (prop) {
      return prop.content;
    }), canExpand(schema, uiSchema, formData) && jsx(AddButton, {
      className: 'object-property-expand',
      onClick: onAddClick(schema),
      disabled: disabled || readonly,
      uiSchema: uiSchema,
      registry: registry
    })]
  });
}

var REQUIRED_FIELD_SYMBOL = '*';
/** The `TitleField` is the template to use to render the title of a field
 *
 * @param props - The `TitleFieldProps` for this component
 */
function TitleField(props) {
  var id = props.id,
    title = props.title,
    required = props.required;
  return jsxs("legend", {
    id: id,
    children: [title, required && jsx("span", {
      className: 'required',
      children: REQUIRED_FIELD_SYMBOL
    })]
  });
}

/** The `UnsupportedField` component is used to render a field in the schema is one that is not supported by
 * react-jsonschema-form.
 *
 * @param props - The `FieldProps` for this template
 */
function UnsupportedField(props) {
  var schema = props.schema,
    idSchema = props.idSchema,
    reason = props.reason,
    registry = props.registry;
  var translateString = registry.translateString;
  var translateEnum = TranslatableString.UnsupportedField;
  var translateParams = [];
  if (idSchema && idSchema.$id) {
    translateEnum = TranslatableString.UnsupportedFieldWithId;
    translateParams.push(idSchema.$id);
  }
  if (reason) {
    translateEnum = translateEnum === TranslatableString.UnsupportedField ? TranslatableString.UnsupportedFieldWithReason : TranslatableString.UnsupportedFieldWithIdAndReason;
    translateParams.push(reason);
  }
  return jsxs("div", {
    className: 'unsupported-field',
    children: [jsx("p", {
      children: jsx(Markdown, {
        children: translateString(translateEnum, translateParams)
      })
    }), schema && jsx("pre", {
      children: JSON.stringify(schema, null, 2)
    })]
  });
}

/** The `WrapIfAdditional` component is used by the `FieldTemplate` to rename, or remove properties that are
 * part of an `additionalProperties` part of a schema.
 *
 * @param props - The `WrapIfAdditionalProps` for this component
 */
function WrapIfAdditionalTemplate(props) {
  var id = props.id,
    classNames = props.classNames,
    style = props.style,
    disabled = props.disabled,
    label = props.label,
    onKeyChange = props.onKeyChange,
    onDropPropertyClick = props.onDropPropertyClick,
    readonly = props.readonly,
    required = props.required,
    schema = props.schema,
    children = props.children,
    uiSchema = props.uiSchema,
    registry = props.registry;
  var templates = registry.templates,
    translateString = registry.translateString;
  // Button templates are not overridden in the uiSchema
  var RemoveButton = templates.ButtonTemplates.RemoveButton;
  var keyLabel = translateString(TranslatableString.KeyLabel, [label]);
  var additional = (ADDITIONAL_PROPERTY_FLAG in schema);
  if (!additional) {
    return jsx("div", {
      className: classNames,
      style: style,
      children: children
    });
  }
  return jsx("div", {
    className: classNames,
    style: style,
    children: jsxs("div", {
      className: 'row',
      children: [jsx("div", {
        className: 'col-xs-5 form-additional',
        children: jsxs("div", {
          className: 'form-group',
          children: [jsx(Label, {
            label: keyLabel,
            required: required,
            id: id + "-key"
          }), jsx("input", {
            className: 'form-control',
            type: 'text',
            id: id + "-key",
            onBlur: function onBlur(event) {
              return onKeyChange(event.target.value);
            },
            defaultValue: label
          })]
        })
      }), jsx("div", {
        className: 'form-additional form-group col-xs-5',
        children: children
      }), jsx("div", {
        className: 'col-xs-2',
        children: jsx(RemoveButton, {
          className: 'array-item-remove btn-block',
          style: {
            border: '0'
          },
          disabled: disabled || readonly,
          onClick: onDropPropertyClick(label),
          uiSchema: uiSchema,
          registry: registry
        })
      })]
    })
  });
}

function templates() {
  return {
    ArrayFieldDescriptionTemplate: ArrayFieldDescriptionTemplate,
    ArrayFieldItemTemplate: ArrayFieldItemTemplate,
    ArrayFieldTemplate: ArrayFieldTemplate,
    ArrayFieldTitleTemplate: ArrayFieldTitleTemplate,
    ButtonTemplates: buttonTemplates(),
    BaseInputTemplate: BaseInputTemplate,
    DescriptionFieldTemplate: DescriptionField,
    ErrorListTemplate: ErrorList,
    FieldTemplate: FieldTemplate,
    FieldErrorTemplate: FieldErrorTemplate,
    FieldHelpTemplate: FieldHelpTemplate,
    ObjectFieldTemplate: ObjectFieldTemplate,
    TitleFieldTemplate: TitleField,
    UnsupportedFieldTemplate: UnsupportedField,
    WrapIfAdditionalTemplate: WrapIfAdditionalTemplate
  };
}

function rangeOptions(start, stop) {
  var options = [];
  for (var i = start; i <= stop; i++) {
    options.push({
      value: i,
      label: pad(i, 2)
    });
  }
  return options;
}
function readyForChange(state) {
  return Object.values(state).every(function (value) {
    return value !== -1;
  });
}
function dateElementProps(state, time, yearsRange) {
  if (yearsRange === void 0) {
    yearsRange = [1900, new Date().getFullYear() + 2];
  }
  var year = state.year,
    month = state.month,
    day = state.day,
    hour = state.hour,
    minute = state.minute,
    second = state.second;
  var data = [{
    type: 'year',
    range: yearsRange,
    value: year
  }, {
    type: 'month',
    range: [1, 12],
    value: month
  }, {
    type: 'day',
    range: [1, 31],
    value: day
  }];
  if (time) {
    data.push({
      type: 'hour',
      range: [0, 23],
      value: hour
    }, {
      type: 'minute',
      range: [0, 59],
      value: minute
    }, {
      type: 'second',
      range: [0, 59],
      value: second
    });
  }
  return data;
}
function DateElement(_ref) {
  var type = _ref.type,
    range = _ref.range,
    value = _ref.value,
    select = _ref.select,
    rootId = _ref.rootId,
    name = _ref.name,
    disabled = _ref.disabled,
    readonly = _ref.readonly,
    autofocus = _ref.autofocus,
    registry = _ref.registry,
    onBlur = _ref.onBlur,
    onFocus = _ref.onFocus;
  var id = rootId + '_' + type;
  var SelectWidget = registry.widgets.SelectWidget;
  return jsx(SelectWidget, {
    schema: {
      type: 'integer'
    },
    id: id,
    name: name,
    className: 'form-control',
    options: {
      enumOptions: rangeOptions(range[0], range[1])
    },
    placeholder: type,
    value: value,
    disabled: disabled,
    readonly: readonly,
    autofocus: autofocus,
    onChange: function onChange(value) {
      return select(type, value);
    },
    onBlur: onBlur,
    onFocus: onFocus,
    registry: registry,
    label: '',
    "aria-describedby": ariaDescribedByIds(rootId)
  });
}
/** The `AltDateWidget` is an alternative widget for rendering date properties.
 * @param props - The `WidgetProps` for this component
 */
function AltDateWidget(_ref2) {
  var _ref2$time = _ref2.time,
    time = _ref2$time === void 0 ? false : _ref2$time,
    _ref2$disabled = _ref2.disabled,
    disabled = _ref2$disabled === void 0 ? false : _ref2$disabled,
    _ref2$readonly = _ref2.readonly,
    readonly = _ref2$readonly === void 0 ? false : _ref2$readonly,
    _ref2$autofocus = _ref2.autofocus,
    autofocus = _ref2$autofocus === void 0 ? false : _ref2$autofocus,
    options = _ref2.options,
    id = _ref2.id,
    name = _ref2.name,
    registry = _ref2.registry,
    onBlur = _ref2.onBlur,
    onFocus = _ref2.onFocus,
    onChange = _ref2.onChange,
    value = _ref2.value;
  var translateString = registry.translateString;
  var _useReducer = useReducer(function (state, action) {
      return _extends({}, state, action);
    }, parseDateString(value, time)),
    state = _useReducer[0],
    setState = _useReducer[1];
  useEffect(function () {
    if (value && value !== toDateString(state, time)) {
      setState(parseDateString(value, time));
    }
  }, [value, state, time]);
  useEffect(function () {
    if (readyForChange(state)) {
      // Only propagate to parent state if we have a complete date{time}
      onChange(toDateString(state, time));
    }
  }, [state, time, onChange]);
  var handleChange = useCallback(function (property, value) {
    var _setState;
    setState((_setState = {}, _setState[property] = value, _setState));
  }, []);
  var handleSetNow = useCallback(function (event) {
    event.preventDefault();
    if (disabled || readonly) {
      return;
    }
    var nowDateObj = parseDateString(new Date().toJSON(), time);
    setState(nowDateObj);
  }, [disabled, readonly, time]);
  var handleClear = useCallback(function (event) {
    event.preventDefault();
    if (disabled || readonly) {
      return;
    }
    setState(parseDateString('', time));
    onChange(undefined);
  }, [disabled, readonly, time, onChange]);
  return jsxs("ul", {
    className: 'list-inline',
    children: [dateElementProps(state, time, options.yearsRange).map(function (elemProps, i) {
      return jsx("li", {
        className: 'list-inline-item',
        children: jsx(DateElement, _extends({
          rootId: id,
          name: name,
          select: handleChange
        }, elemProps, {
          disabled: disabled,
          readonly: readonly,
          registry: registry,
          onBlur: onBlur,
          onFocus: onFocus,
          autofocus: autofocus && i === 0
        }))
      }, i);
    }), (options.hideNowButton !== 'undefined' ? !options.hideNowButton : true) && jsx("li", {
      className: 'list-inline-item',
      children: jsx("a", {
        href: '#',
        className: 'btn btn-info btn-now',
        onClick: handleSetNow,
        children: translateString(TranslatableString.NowLabel)
      })
    }), (options.hideClearButton !== 'undefined' ? !options.hideClearButton : true) && jsx("li", {
      className: 'list-inline-item',
      children: jsx("a", {
        href: '#',
        className: 'btn btn-warning btn-clear',
        onClick: handleClear,
        children: translateString(TranslatableString.ClearLabel)
      })
    })]
  });
}

var _excluded$1 = ["time"];
/** The `AltDateTimeWidget` is an alternative widget for rendering datetime properties.
 *  It uses the AltDateWidget for rendering, with the `time` prop set to true by default.
 *
 * @param props - The `WidgetProps` for this component
 */
function AltDateTimeWidget(_ref) {
  var _ref$time = _ref.time,
    time = _ref$time === void 0 ? true : _ref$time,
    props = _objectWithoutPropertiesLoose(_ref, _excluded$1);
  var AltDateWidget = props.registry.widgets.AltDateWidget;
  return jsx(AltDateWidget, _extends({
    time: time
  }, props));
}

/** The `CheckBoxWidget` is a widget for rendering boolean properties.
 *  It is typically used to represent a boolean.
 *
 * @param props - The `WidgetProps` for this component
 */
function CheckboxWidget(_ref) {
  var schema = _ref.schema,
    uiSchema = _ref.uiSchema,
    options = _ref.options,
    id = _ref.id,
    value = _ref.value,
    disabled = _ref.disabled,
    readonly = _ref.readonly,
    label = _ref.label,
    _ref$autofocus = _ref.autofocus,
    autofocus = _ref$autofocus === void 0 ? false : _ref$autofocus,
    onBlur = _ref.onBlur,
    onFocus = _ref.onFocus,
    onChange = _ref.onChange,
    registry = _ref.registry;
  var DescriptionFieldTemplate = getTemplate('DescriptionFieldTemplate', registry, options);
  // Because an unchecked checkbox will cause html5 validation to fail, only add
  // the "required" attribute if the field value must be "true", due to the
  // "const" or "enum" keywords
  var required = schemaRequiresTrueValue(schema);
  var handleChange = useCallback(function (event) {
    return onChange(event.target.checked);
  }, [onChange]);
  var handleBlur = useCallback(function (event) {
    return onBlur(id, event.target.checked);
  }, [onBlur, id]);
  var handleFocus = useCallback(function (event) {
    return onFocus(id, event.target.checked);
  }, [onFocus, id]);
  return jsxs("div", {
    className: "checkbox " + (disabled || readonly ? 'disabled' : ''),
    children: [schema.description && jsx(DescriptionFieldTemplate, {
      id: descriptionId(id),
      description: schema.description,
      schema: schema,
      uiSchema: uiSchema,
      registry: registry
    }), jsxs("label", {
      children: [jsx("input", {
        type: 'checkbox',
        id: id,
        name: id,
        checked: typeof value === 'undefined' ? false : value,
        required: required,
        disabled: disabled || readonly,
        autoFocus: autofocus,
        onChange: handleChange,
        onBlur: handleBlur,
        onFocus: handleFocus,
        "aria-describedby": ariaDescribedByIds(id)
      }), jsx("span", {
        children: label
      })]
    })]
  });
}

/** The `CheckboxesWidget` is a widget for rendering checkbox groups.
 *  It is typically used to represent an array of enums.
 *
 * @param props - The `WidgetProps` for this component
 */
function CheckboxesWidget(_ref) {
  var id = _ref.id,
    disabled = _ref.disabled,
    _ref$options = _ref.options,
    _ref$options$inline = _ref$options.inline,
    inline = _ref$options$inline === void 0 ? false : _ref$options$inline,
    enumOptions = _ref$options.enumOptions,
    enumDisabled = _ref$options.enumDisabled,
    emptyValue = _ref$options.emptyValue,
    value = _ref.value,
    _ref$autofocus = _ref.autofocus,
    autofocus = _ref$autofocus === void 0 ? false : _ref$autofocus,
    readonly = _ref.readonly,
    onChange = _ref.onChange,
    onBlur = _ref.onBlur,
    onFocus = _ref.onFocus;
  var checkboxesValues = Array.isArray(value) ? value : [value];
  var handleBlur = useCallback(function (_ref2) {
    var value = _ref2.target.value;
    return onBlur(id, enumOptionsValueForIndex(value, enumOptions, emptyValue));
  }, [onBlur, id]);
  var handleFocus = useCallback(function (_ref3) {
    var value = _ref3.target.value;
    return onFocus(id, enumOptionsValueForIndex(value, enumOptions, emptyValue));
  }, [onFocus, id]);
  return jsx("div", {
    className: 'checkboxes',
    id: id,
    children: Array.isArray(enumOptions) && enumOptions.map(function (option, index) {
      var checked = enumOptionsIsSelected(option.value, checkboxesValues);
      var itemDisabled = Array.isArray(enumDisabled) && enumDisabled.indexOf(option.value) !== -1;
      var disabledCls = disabled || itemDisabled || readonly ? 'disabled' : '';
      var handleChange = function handleChange(event) {
        if (event.target.checked) {
          onChange(enumOptionsSelectValue(index, checkboxesValues, enumOptions));
        } else {
          onChange(enumOptionsDeselectValue(index, checkboxesValues, enumOptions));
        }
      };
      var checkbox = jsxs("span", {
        children: [jsx("input", {
          type: 'checkbox',
          id: optionId(id, index),
          name: id,
          checked: checked,
          value: String(index),
          disabled: disabled || itemDisabled || readonly,
          autoFocus: autofocus && index === 0,
          onChange: handleChange,
          onBlur: handleBlur,
          onFocus: handleFocus,
          "aria-describedby": ariaDescribedByIds(id)
        }), jsx("span", {
          children: option.label
        })]
      });
      return inline ? jsx("label", {
        className: "checkbox-inline " + disabledCls,
        children: checkbox
      }, index) : jsx("div", {
        className: "checkbox " + disabledCls,
        children: jsx("label", {
          children: checkbox
        })
      }, index);
    })
  });
}

/** The `ColorWidget` component uses the `BaseInputTemplate` changing the type to `color` and disables it when it is
 * either disabled or readonly.
 *
 * @param props - The `WidgetProps` for this component
 */
function ColorWidget(props) {
  var disabled = props.disabled,
    readonly = props.readonly,
    options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  return jsx(BaseInputTemplate, _extends({
    type: 'color'
  }, props, {
    disabled: disabled || readonly
  }));
}

/** The `DateWidget` component uses the `BaseInputTemplate` changing the type to `date` and transforms
 * the value to undefined when it is falsy during the `onChange` handling.
 *
 * @param props - The `WidgetProps` for this component
 */
function DateWidget(props) {
  var onChange = props.onChange,
    options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  var handleChange = useCallback(function (value) {
    return onChange(value || undefined);
  }, [onChange]);
  return jsx(BaseInputTemplate, _extends({
    type: 'date'
  }, props, {
    onChange: handleChange
  }));
}

/** The `DateTimeWidget` component uses the `BaseInputTemplate` changing the type to `datetime-local` and transforms
 * the value to/from utc using the appropriate utility functions.
 *
 * @param props - The `WidgetProps` for this component
 */
function DateTimeWidget(props) {
  var _onChange = props.onChange,
    value = props.value,
    options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  return jsx(BaseInputTemplate, _extends({
    type: 'datetime-local'
  }, props, {
    value: utcToLocal(value),
    onChange: function onChange(value) {
      return _onChange(localToUTC(value));
    }
  }));
}

/** The `EmailWidget` component uses the `BaseInputTemplate` changing the type to `email`.
 *
 * @param props - The `WidgetProps` for this component
 */
function EmailWidget(props) {
  var options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  return jsx(BaseInputTemplate, _extends({
    type: 'email'
  }, props));
}

function addNameToDataURL(dataURL, name) {
  if (dataURL === null) {
    return null;
  }
  return dataURL.replace(';base64', ";name=" + encodeURIComponent(name) + ";base64");
}
function processFile(file) {
  var name = file.name,
    size = file.size,
    type = file.type;
  return new Promise(function (resolve, reject) {
    var reader = new window.FileReader();
    reader.onerror = reject;
    reader.onload = function (event) {
      var _event$target;
      if (typeof ((_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.result) === 'string') {
        resolve({
          dataURL: addNameToDataURL(event.target.result, name),
          name: name,
          size: size,
          type: type
        });
      } else {
        resolve({
          dataURL: null,
          name: name,
          size: size,
          type: type
        });
      }
    };
    reader.readAsDataURL(file);
  });
}
function processFiles(files) {
  return Promise.all(Array.from(files).map(processFile));
}
function FilesInfo(_ref) {
  var filesInfo = _ref.filesInfo,
    registry = _ref.registry;
  if (filesInfo.length === 0) {
    return null;
  }
  var translateString = registry.translateString;
  return jsx("ul", {
    className: 'file-info',
    children: filesInfo.map(function (fileInfo, key) {
      var name = fileInfo.name,
        size = fileInfo.size,
        type = fileInfo.type;
      return jsx("li", {
        children: jsx(Markdown, {
          children: translateString(TranslatableString.FilesInfo, [name, type, String(size)])
        })
      }, key);
    })
  });
}
function extractFileInfo(dataURLs) {
  return dataURLs.filter(function (dataURL) {
    return dataURL;
  }).map(function (dataURL) {
    var _dataURItoBlob = dataURItoBlob(dataURL),
      blob = _dataURItoBlob.blob,
      name = _dataURItoBlob.name;
    return {
      name: name,
      size: blob.size,
      type: blob.type
    };
  });
}
/**
 *  The `FileWidget` is a widget for rendering file upload fields.
 *  It is typically used with a string property with data-url format.
 */
function FileWidget(props) {
  var disabled = props.disabled,
    readonly = props.readonly,
    multiple = props.multiple,
    onChange = props.onChange,
    value = props.value,
    options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  var extractedFilesInfo = useMemo(function () {
    return Array.isArray(value) ? extractFileInfo(value) : extractFileInfo([value]);
  }, [value]);
  var _useState = useState(extractedFilesInfo),
    filesInfo = _useState[0],
    setFilesInfo = _useState[1];
  var handleChange = useCallback(function (event) {
    if (!event.target.files) {
      return;
    }
    processFiles(event.target.files).then(function (filesInfoEvent) {
      setFilesInfo(filesInfoEvent);
      var newValue = filesInfoEvent.map(function (fileInfo) {
        return fileInfo.dataURL;
      });
      if (multiple) {
        onChange(newValue);
      } else {
        onChange(newValue[0]);
      }
    });
  }, [multiple, onChange]);
  return jsxs("div", {
    children: [jsx(BaseInputTemplate, _extends({}, props, {
      disabled: disabled || readonly,
      type: 'file',
      onChangeOverride: handleChange,
      value: '',
      accept: options.accept ? String(options.accept) : undefined
    })), jsx(FilesInfo, {
      filesInfo: filesInfo,
      registry: registry
    })]
  });
}

/** The `HiddenWidget` is a widget for rendering a hidden input field.
 *  It is typically used by setting type to "hidden".
 *
 * @param props - The `WidgetProps` for this component
 */
function HiddenWidget(_ref) {
  var id = _ref.id,
    value = _ref.value;
  return jsx("input", {
    type: 'hidden',
    id: id,
    name: id,
    value: typeof value === 'undefined' ? '' : value
  });
}

/** The `PasswordWidget` component uses the `BaseInputTemplate` changing the type to `password`.
 *
 * @param props - The `WidgetProps` for this component
 */
function PasswordWidget(props) {
  var options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  return jsx(BaseInputTemplate, _extends({
    type: 'password'
  }, props));
}

/** The `RadioWidget` is a widget for rendering a radio group.
 *  It is typically used with a string property constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function RadioWidget(_ref) {
  var options = _ref.options,
    value = _ref.value,
    required = _ref.required,
    disabled = _ref.disabled,
    readonly = _ref.readonly,
    _ref$autofocus = _ref.autofocus,
    autofocus = _ref$autofocus === void 0 ? false : _ref$autofocus,
    onBlur = _ref.onBlur,
    onFocus = _ref.onFocus,
    onChange = _ref.onChange,
    id = _ref.id;
  // Generating a unique field name to identify this set of radio buttons
  var name = Math.random().toString();
  var enumOptions = options.enumOptions,
    enumDisabled = options.enumDisabled,
    inline = options.inline,
    emptyValue = options.emptyValue;
  var handleBlur = useCallback(function (_ref2) {
    var value = _ref2.target.value;
    return onBlur(id, enumOptionsValueForIndex(value, enumOptions, emptyValue));
  }, [onBlur, id]);
  var handleFocus = useCallback(function (_ref3) {
    var value = _ref3.target.value;
    return onFocus(id, enumOptionsValueForIndex(value, enumOptions, emptyValue));
  }, [onFocus, id]);
  return jsx("div", {
    className: 'field-radio-group',
    id: id,
    children: Array.isArray(enumOptions) && enumOptions.map(function (option, i) {
      var checked = enumOptionsIsSelected(option.value, value);
      var itemDisabled = Array.isArray(enumDisabled) && enumDisabled.indexOf(option.value) !== -1;
      var disabledCls = disabled || itemDisabled || readonly ? 'disabled' : '';
      var handleChange = function handleChange() {
        return onChange(option.value);
      };
      var radio = jsxs("span", {
        children: [jsx("input", {
          type: 'radio',
          id: optionId(id, i),
          checked: checked,
          name: name,
          required: required,
          value: String(i),
          disabled: disabled || itemDisabled || readonly,
          autoFocus: autofocus && i === 0,
          onChange: handleChange,
          onBlur: handleBlur,
          onFocus: handleFocus,
          "aria-describedby": ariaDescribedByIds(id)
        }), jsx("span", {
          children: option.label
        })]
      });
      return inline ? jsx("label", {
        className: "radio-inline " + disabledCls,
        children: radio
      }, i) : jsx("div", {
        className: "radio " + disabledCls,
        children: jsx("label", {
          children: radio
        })
      }, i);
    })
  });
}

/** The `RangeWidget` component uses the `BaseInputTemplate` changing the type to `range` and wrapping the result
 * in a div, with the value along side it.
 *
 * @param props - The `WidgetProps` for this component
 */
function RangeWidget(props) {
  var value = props.value,
    BaseInputTemplate = props.registry.templates.BaseInputTemplate;
  return jsxs("div", {
    className: 'field-range-wrapper',
    children: [jsx(BaseInputTemplate, _extends({
      type: 'range'
    }, props)), jsx("span", {
      className: 'range-view',
      children: value
    })]
  });
}

function getValue(event, multiple) {
  if (multiple) {
    return Array.from(event.target.options).slice().filter(function (o) {
      return o.selected;
    }).map(function (o) {
      return o.value;
    });
  }
  return event.target.value;
}
/** The `SelectWidget` is a widget for rendering dropdowns.
 *  It is typically used with string properties constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function SelectWidget(_ref) {
  var schema = _ref.schema,
    id = _ref.id,
    options = _ref.options,
    value = _ref.value,
    required = _ref.required,
    disabled = _ref.disabled,
    readonly = _ref.readonly,
    _ref$multiple = _ref.multiple,
    multiple = _ref$multiple === void 0 ? false : _ref$multiple,
    _ref$autofocus = _ref.autofocus,
    autofocus = _ref$autofocus === void 0 ? false : _ref$autofocus,
    onChange = _ref.onChange,
    onBlur = _ref.onBlur,
    onFocus = _ref.onFocus,
    placeholder = _ref.placeholder;
  var enumOptions = options.enumOptions,
    enumDisabled = options.enumDisabled,
    optEmptyVal = options.emptyValue;
  var emptyValue = multiple ? [] : '';
  var handleFocus = useCallback(function (event) {
    var newValue = getValue(event, multiple);
    return onFocus(id, enumOptionsValueForIndex(newValue, enumOptions, optEmptyVal));
  }, [onFocus, id, schema, multiple, options]);
  var handleBlur = useCallback(function (event) {
    var newValue = getValue(event, multiple);
    return onBlur(id, enumOptionsValueForIndex(newValue, enumOptions, optEmptyVal));
  }, [onBlur, id, schema, multiple, options]);
  var handleChange = useCallback(function (event) {
    var newValue = getValue(event, multiple);
    return onChange(enumOptionsValueForIndex(newValue, enumOptions, optEmptyVal));
  }, [onChange, schema, multiple, options]);
  var selectedIndexes = enumOptionsIndexForValue(value, enumOptions, multiple);
  return jsxs("select", {
    id: id,
    name: id,
    multiple: multiple,
    className: 'form-control',
    value: typeof selectedIndexes === 'undefined' ? emptyValue : selectedIndexes,
    required: required,
    disabled: disabled || readonly,
    autoFocus: autofocus,
    onBlur: handleBlur,
    onFocus: handleFocus,
    onChange: handleChange,
    "aria-describedby": ariaDescribedByIds(id),
    children: [!multiple && schema["default"] === undefined && jsx("option", {
      value: '',
      children: placeholder
    }), Array.isArray(enumOptions) && enumOptions.map(function (_ref2, i) {
      var value = _ref2.value,
        label = _ref2.label;
      var disabled = enumDisabled && enumDisabled.indexOf(value) !== -1;
      return jsx("option", {
        value: String(i),
        disabled: disabled,
        children: label
      }, i);
    })]
  });
}

/** The `TextareaWidget` is a widget for rendering input fields as textarea.
 *
 * @param props - The `WidgetProps` for this component
 */
function TextareaWidget(_ref) {
  var id = _ref.id,
    _ref$options = _ref.options,
    options = _ref$options === void 0 ? {} : _ref$options,
    placeholder = _ref.placeholder,
    value = _ref.value,
    required = _ref.required,
    disabled = _ref.disabled,
    readonly = _ref.readonly,
    _ref$autofocus = _ref.autofocus,
    autofocus = _ref$autofocus === void 0 ? false : _ref$autofocus,
    onChange = _ref.onChange,
    onBlur = _ref.onBlur,
    onFocus = _ref.onFocus;
  var handleChange = useCallback(function (_ref2) {
    var value = _ref2.target.value;
    return onChange(value === '' ? options.emptyValue : value);
  }, [onChange, options.emptyValue]);
  var handleBlur = useCallback(function (_ref3) {
    var value = _ref3.target.value;
    return onBlur(id, value);
  }, [onBlur, id]);
  var handleFocus = useCallback(function (_ref4) {
    var value = _ref4.target.value;
    return onFocus(id, value);
  }, [id, onFocus]);
  return jsx("textarea", {
    id: id,
    name: id,
    className: 'form-control',
    value: value ? value : '',
    placeholder: placeholder,
    required: required,
    disabled: disabled,
    readOnly: readonly,
    autoFocus: autofocus,
    rows: options.rows,
    onBlur: handleBlur,
    onFocus: handleFocus,
    onChange: handleChange,
    "aria-describedby": ariaDescribedByIds(id)
  });
}
TextareaWidget.defaultProps = {
  autofocus: false,
  options: {}
};

/** The `TextWidget` component uses the `BaseInputTemplate`.
 *
 * @param props - The `WidgetProps` for this component
 */
function TextWidget(props) {
  var options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  return jsx(BaseInputTemplate, _extends({}, props));
}

/** The `URLWidget` component uses the `BaseInputTemplate` changing the type to `url`.
 *
 * @param props - The `WidgetProps` for this component
 */
function URLWidget(props) {
  var options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  return jsx(BaseInputTemplate, _extends({
    type: 'url'
  }, props));
}

/** The `UpDownWidget` component uses the `BaseInputTemplate` changing the type to `number`.
 *
 * @param props - The `WidgetProps` for this component
 */
function UpDownWidget(props) {
  var options = props.options,
    registry = props.registry;
  var BaseInputTemplate = getTemplate('BaseInputTemplate', registry, options);
  return jsx(BaseInputTemplate, _extends({
    type: 'number'
  }, props));
}

function widgets() {
  return {
    PasswordWidget: PasswordWidget,
    RadioWidget: RadioWidget,
    UpDownWidget: UpDownWidget,
    RangeWidget: RangeWidget,
    SelectWidget: SelectWidget,
    TextWidget: TextWidget,
    DateWidget: DateWidget,
    DateTimeWidget: DateTimeWidget,
    AltDateWidget: AltDateWidget,
    AltDateTimeWidget: AltDateTimeWidget,
    EmailWidget: EmailWidget,
    URLWidget: URLWidget,
    TextareaWidget: TextareaWidget,
    HiddenWidget: HiddenWidget,
    ColorWidget: ColorWidget,
    FileWidget: FileWidget,
    CheckboxWidget: CheckboxWidget,
    CheckboxesWidget: CheckboxesWidget
  };
}

/** The default registry consists of all the fields, templates and widgets provided in the core implementation,
 * plus an empty `rootSchema` and `formContext. We omit schemaUtils here because it cannot be defaulted without a
 * rootSchema and validator. It will be added into the computed registry later in the Form.
 */
function getDefaultRegistry() {
  return {
    fields: fields(),
    templates: templates(),
    widgets: widgets(),
    rootSchema: {},
    formContext: {},
    translateString: englishStringTranslator
  };
}

/** The `Form` component renders the outer form and all the fields defined in the `schema` */
var Form = /*#__PURE__*/function (_Component) {
  _inheritsLoose(Form, _Component);
  /** The ref used to hold the `form` element, this needs to be `any` because `tagName` or `_internalFormWrapper` can
   * provide any possible type here
   */

  /** Constructs the `Form` from the `props`. Will setup the initial state from the props. It will also call the
   * `onChange` handler if the initially provided `formData` is modified to add missing default values as part of the
   * state construction.
   *
   * @param props - The initial props for the `Form`
   */
  function Form(props) {
    var _this;
    _this = _Component.call(this, props) || this;
    _this.formElement = void 0;
    _this.getUsedFormData = function (formData, fields) {
      // For the case of a single input form
      if (fields.length === 0 && typeof formData !== 'object') {
        return formData;
      }
      // _pick has incorrect type definition, it works with string[][], because lodash/hasIn supports it
      var data = _pick(formData, fields);
      if (Array.isArray(formData)) {
        return Object.keys(data).map(function (key) {
          return data[key];
        });
      }
      return data;
    };
    _this.getFieldNames = function (pathSchema, formData) {
      var getAllPaths = function getAllPaths(_obj, acc, paths) {
        if (acc === void 0) {
          acc = [];
        }
        if (paths === void 0) {
          paths = [[]];
        }
        Object.keys(_obj).forEach(function (key) {
          if (typeof _obj[key] === 'object') {
            var newPaths = paths.map(function (path) {
              return [].concat(path, [key]);
            });
            // If an object is marked with additionalProperties, all its keys are valid
            if (_obj[key][RJSF_ADDITONAL_PROPERTIES_FLAG] && _obj[key][NAME_KEY] !== '') {
              acc.push(_obj[key][NAME_KEY]);
            } else {
              getAllPaths(_obj[key], acc, newPaths);
            }
          } else if (key === NAME_KEY && _obj[key] !== '') {
            paths.forEach(function (path) {
              var formValue = get(formData, path);
              // adds path to fieldNames if it points to a value
              // or an empty object/array
              if (typeof formValue !== 'object' || isEmpty(formValue)) {
                acc.push(path);
              }
            });
          }
        });
        return acc;
      };
      return getAllPaths(pathSchema);
    };
    _this.onChange = function (formData, newErrorSchema, id) {
      var _this$props = _this.props,
        extraErrors = _this$props.extraErrors,
        omitExtraData = _this$props.omitExtraData,
        liveOmit = _this$props.liveOmit,
        noValidate = _this$props.noValidate,
        liveValidate = _this$props.liveValidate,
        onChange = _this$props.onChange;
      var _this$state = _this.state,
        schemaUtils = _this$state.schemaUtils,
        schema = _this$state.schema;
      if (isObject$1(formData) || Array.isArray(formData)) {
        var newState = _this.getStateFromProps(_this.props, formData);
        formData = newState.formData;
      }
      var mustValidate = !noValidate && liveValidate;
      var state = {
        formData: formData,
        schema: schema
      };
      var newFormData = formData;
      if (omitExtraData === true && liveOmit === true) {
        var retrievedSchema = schemaUtils.retrieveSchema(schema, formData);
        var pathSchema = schemaUtils.toPathSchema(retrievedSchema, '', formData);
        var fieldNames = _this.getFieldNames(pathSchema, formData);
        newFormData = _this.getUsedFormData(formData, fieldNames);
        state = {
          formData: newFormData
        };
      }
      if (mustValidate) {
        var schemaValidation = _this.validate(newFormData);
        var errors = schemaValidation.errors;
        var errorSchema = schemaValidation.errorSchema;
        var schemaValidationErrors = errors;
        var schemaValidationErrorSchema = errorSchema;
        if (extraErrors) {
          var merged = schemaUtils.mergeValidationData(schemaValidation, extraErrors);
          errorSchema = merged.errorSchema;
          errors = merged.errors;
        }
        state = {
          formData: newFormData,
          errors: errors,
          errorSchema: errorSchema,
          schemaValidationErrors: schemaValidationErrors,
          schemaValidationErrorSchema: schemaValidationErrorSchema
        };
      } else if (!noValidate && newErrorSchema) {
        var _errorSchema = extraErrors ? mergeObjects(newErrorSchema, extraErrors, 'preventDuplicates') : newErrorSchema;
        state = {
          formData: newFormData,
          errorSchema: _errorSchema,
          errors: schemaUtils.getValidator().toErrorList(_errorSchema)
        };
      }
      _this.setState(state, function () {
        return onChange && onChange(_extends({}, _this.state, state), id);
      });
    };
    _this.onBlur = function (id, data) {
      var onBlur = _this.props.onBlur;
      if (onBlur) {
        onBlur(id, data);
      }
    };
    _this.onFocus = function (id, data) {
      var onFocus = _this.props.onFocus;
      if (onFocus) {
        onFocus(id, data);
      }
    };
    _this.onSubmit = function (event) {
      event.preventDefault();
      if (event.target !== event.currentTarget) {
        return;
      }
      event.persist();
      var _this$props2 = _this.props,
        omitExtraData = _this$props2.omitExtraData,
        extraErrors = _this$props2.extraErrors,
        noValidate = _this$props2.noValidate,
        onSubmit = _this$props2.onSubmit;
      var newFormData = _this.state.formData;
      var _this$state2 = _this.state,
        schema = _this$state2.schema,
        schemaUtils = _this$state2.schemaUtils;
      if (omitExtraData === true) {
        var retrievedSchema = schemaUtils.retrieveSchema(schema, newFormData);
        var pathSchema = schemaUtils.toPathSchema(retrievedSchema, '', newFormData);
        var fieldNames = _this.getFieldNames(pathSchema, newFormData);
        newFormData = _this.getUsedFormData(newFormData, fieldNames);
      }
      if (noValidate || _this.validateForm()) {
        // There are no errors generated through schema validation.
        // Check for user provided errors and update state accordingly.
        var errorSchema = extraErrors || {};
        var errors = extraErrors ? schemaUtils.getValidator().toErrorList(extraErrors) : [];
        _this.setState({
          formData: newFormData,
          errors: errors,
          errorSchema: errorSchema,
          schemaValidationErrors: [],
          schemaValidationErrorSchema: {}
        }, function () {
          if (onSubmit) {
            onSubmit(_extends({}, _this.state, {
              formData: newFormData,
              status: 'submitted'
            }), event);
          }
        });
      }
    };
    if (!props.validator) {
      throw new Error('A validator is required for Form functionality to work');
    }
    _this.state = _this.getStateFromProps(props, props.formData);
    if (_this.props.onChange && !deepEquals(_this.state.formData, _this.props.formData)) {
      _this.props.onChange(_this.state);
    }
    _this.formElement = /*#__PURE__*/createRef();
    return _this;
  }
  /** React lifecycle method that gets called before new props are provided, updates the state based on new props. It
   * will also call the`onChange` handler if the `formData` is modified to add missing default values as part of the
   * state construction.
   *
   * @param nextProps - The new set of props about to be applied to the `Form`
   */
  var _proto = Form.prototype;
  _proto.UNSAFE_componentWillReceiveProps = function UNSAFE_componentWillReceiveProps(nextProps) {
    var nextState = this.getStateFromProps(nextProps, nextProps.formData);
    if (!deepEquals(nextState.formData, nextProps.formData) && !deepEquals(nextState.formData, this.state.formData) && nextProps.onChange) {
      nextProps.onChange(nextState);
    }
    this.setState(nextState);
  }
  /** Extracts the updated state from the given `props` and `inputFormData`. As part of this process, the
   * `inputFormData` is first processed to add any missing required defaults. After that, the data is run through the
   * validation process IF required by the `props`.
   *
   * @param props - The props passed to the `Form`
   * @param inputFormData - The new or current data for the `Form`
   * @returns - The new state for the `Form`
   */;
  _proto.getStateFromProps = function getStateFromProps(props, inputFormData) {
    var state = this.state || {};
    var schema = 'schema' in props ? props.schema : this.props.schema;
    var uiSchema = ('uiSchema' in props ? props.uiSchema : this.props.uiSchema) || {};
    var edit = typeof inputFormData !== 'undefined';
    var liveValidate = 'liveValidate' in props ? props.liveValidate : this.props.liveValidate;
    var mustValidate = edit && !props.noValidate && liveValidate;
    var rootSchema = schema;
    var schemaUtils = state.schemaUtils;
    if (!schemaUtils || schemaUtils.doesSchemaUtilsDiffer(props.validator, rootSchema)) {
      schemaUtils = createSchemaUtils(props.validator, rootSchema);
    }
    var formData = schemaUtils.getDefaultFormState(schema, inputFormData);
    var retrievedSchema = schemaUtils.retrieveSchema(schema, formData);
    var getCurrentErrors = function getCurrentErrors() {
      if (props.noValidate) {
        return {
          errors: [],
          errorSchema: {}
        };
      } else if (!props.liveValidate) {
        return {
          errors: state.schemaValidationErrors || [],
          errorSchema: state.schemaValidationErrorSchema || {}
        };
      }
      return {
        errors: state.errors || [],
        errorSchema: state.errorSchema || {}
      };
    };
    var errors;
    var errorSchema;
    var schemaValidationErrors = state.schemaValidationErrors;
    var schemaValidationErrorSchema = state.schemaValidationErrorSchema;
    if (mustValidate) {
      var schemaValidation = this.validate(formData, schema, schemaUtils);
      errors = schemaValidation.errors;
      errorSchema = schemaValidation.errorSchema;
      schemaValidationErrors = errors;
      schemaValidationErrorSchema = errorSchema;
    } else {
      var currentErrors = getCurrentErrors();
      errors = currentErrors.errors;
      errorSchema = currentErrors.errorSchema;
    }
    if (props.extraErrors) {
      var merged = schemaUtils.mergeValidationData({
        errorSchema: errorSchema,
        errors: errors
      }, props.extraErrors);
      errorSchema = merged.errorSchema;
      errors = merged.errors;
    }
    var idSchema = schemaUtils.toIdSchema(retrievedSchema, uiSchema['ui:rootFieldId'], formData, props.idPrefix, props.idSeparator);
    var nextState = {
      schemaUtils: schemaUtils,
      schema: schema,
      uiSchema: uiSchema,
      idSchema: idSchema,
      formData: formData,
      edit: edit,
      errors: errors,
      errorSchema: errorSchema,
      schemaValidationErrors: schemaValidationErrors,
      schemaValidationErrorSchema: schemaValidationErrorSchema
    };
    return nextState;
  }
  /** React lifecycle method that is used to determine whether component should be updated.
   *
   * @param nextProps - The next version of the props
   * @param nextState - The next version of the state
   * @returns - True if the component should be updated, false otherwise
   */;
  _proto.shouldComponentUpdate = function shouldComponentUpdate(nextProps, nextState) {
    return shouldRender(this, nextProps, nextState);
  }
  /** Validates the `formData` against the `schema` using the `altSchemaUtils` (if provided otherwise it uses the
   * `schemaUtils` in the state), returning the results.
   *
   * @param formData - The new form data to validate
   * @param schema - The schema used to validate against
   * @param altSchemaUtils - The alternate schemaUtils to use for validation
   */;
  _proto.validate = function validate(formData, schema, altSchemaUtils) {
    if (schema === void 0) {
      schema = this.props.schema;
    }
    var schemaUtils = altSchemaUtils ? altSchemaUtils : this.state.schemaUtils;
    var _this$props3 = this.props,
      customValidate = _this$props3.customValidate,
      transformErrors = _this$props3.transformErrors,
      uiSchema = _this$props3.uiSchema;
    var resolvedSchema = schemaUtils.retrieveSchema(schema, formData);
    return schemaUtils.getValidator().validateFormData(formData, resolvedSchema, customValidate, transformErrors, uiSchema);
  }
  /** Renders any errors contained in the `state` in using the `ErrorList`, if not disabled by `showErrorList`. */;
  _proto.renderErrors = function renderErrors(registry) {
    var _this$state3 = this.state,
      errors = _this$state3.errors,
      errorSchema = _this$state3.errorSchema,
      schema = _this$state3.schema,
      uiSchema = _this$state3.uiSchema;
    var formContext = this.props.formContext;
    var options = getUiOptions(uiSchema);
    var ErrorListTemplate = getTemplate('ErrorListTemplate', registry, options);
    if (errors && errors.length) {
      return jsx(ErrorListTemplate, {
        errors: errors,
        errorSchema: errorSchema || {},
        schema: schema,
        uiSchema: uiSchema,
        formContext: formContext,
        registry: registry
      });
    }
    return null;
  }
  /** Returns the `formData` with only the elements specified in the `fields` list
   *
   * @param formData - The data for the `Form`
   * @param fields - The fields to keep while filtering
   */;
  /** Returns the registry for the form */
  _proto.getRegistry = function getRegistry() {
    var _this$props$templates;
    var customTranslateString = this.props.translateString;
    var schemaUtils = this.state.schemaUtils;
    var _getDefaultRegistry = getDefaultRegistry(),
      fields = _getDefaultRegistry.fields,
      templates = _getDefaultRegistry.templates,
      widgets = _getDefaultRegistry.widgets,
      formContext = _getDefaultRegistry.formContext,
      translateString = _getDefaultRegistry.translateString;
    return {
      fields: _extends({}, fields, this.props.fields),
      templates: _extends({}, templates, this.props.templates, {
        ButtonTemplates: _extends({}, templates.ButtonTemplates, (_this$props$templates = this.props.templates) === null || _this$props$templates === void 0 ? void 0 : _this$props$templates.ButtonTemplates)
      }),
      widgets: _extends({}, widgets, this.props.widgets),
      rootSchema: this.props.schema,
      formContext: this.props.formContext || formContext,
      schemaUtils: schemaUtils,
      translateString: customTranslateString || translateString
    };
  }
  /** Provides a function that can be used to programmatically submit the `Form` */;
  _proto.submit = function submit() {
    if (this.formElement.current) {
      this.formElement.current.dispatchEvent(new CustomEvent('submit', {
        cancelable: true
      }));
      this.formElement.current.requestSubmit();
    }
  }
  /** Attempts to focus on the field associated with the `error`. Uses the `property` field to compute path of the error
   * field, then, using the `idPrefix` and `idSeparator` converts that path into an id. Then the input element with that
   * id is attempted to be found using the `formElement` ref. If it is located, then it is focused.
   *
   * @param error - The error on which to focus
   */;
  _proto.focusOnError = function focusOnError(error) {
    var _this$props4 = this.props,
      _this$props4$idPrefix = _this$props4.idPrefix,
      idPrefix = _this$props4$idPrefix === void 0 ? 'root' : _this$props4$idPrefix,
      _this$props4$idSepara = _this$props4.idSeparator,
      idSeparator = _this$props4$idSepara === void 0 ? '_' : _this$props4$idSepara;
    var property = error.property;
    var path = _toPath(property);
    if (path[0] === '') {
      // Most of the time the `.foo` property results in the first element being empty, so replace it with the idPrefix
      path[0] = idPrefix;
    } else {
      // Otherwise insert the idPrefix into the first location using unshift
      path.unshift(idPrefix);
    }
    var elementId = path.join(idSeparator);
    var field = this.formElement.current.elements[elementId];
    if (!field) {
      // if not an exact match, try finding an input starting with the element id (like radio buttons or checkboxes)
      field = this.formElement.current.querySelector("input[id^=" + elementId);
    }
    if (field) {
      field.focus();
    }
  }
  /** Programmatically validate the form. If `onError` is provided, then it will be called with the list of errors the
   * same way as would happen on form submission.
   *
   * @returns - True if the form is valid, false otherwise.
   */;
  _proto.validateForm = function validateForm() {
    var _this$props5 = this.props,
      extraErrors = _this$props5.extraErrors,
      focusOnFirstError = _this$props5.focusOnFirstError,
      onError = _this$props5.onError;
    var formData = this.state.formData;
    var schemaUtils = this.state.schemaUtils;
    var schemaValidation = this.validate(formData);
    var errors = schemaValidation.errors;
    var errorSchema = schemaValidation.errorSchema;
    var schemaValidationErrors = errors;
    var schemaValidationErrorSchema = errorSchema;
    if (errors.length > 0) {
      if (extraErrors) {
        var merged = schemaUtils.mergeValidationData(schemaValidation, extraErrors);
        errorSchema = merged.errorSchema;
        errors = merged.errors;
      }
      if (focusOnFirstError) {
        this.focusOnError(schemaValidation.errors[0]);
      }
      this.setState({
        errors: errors,
        errorSchema: errorSchema,
        schemaValidationErrors: schemaValidationErrors,
        schemaValidationErrorSchema: schemaValidationErrorSchema
      }, function () {
        if (onError) {
          onError(errors);
        } else {
          console.error('Form validation failed', errors);
        }
      });
      return false;
    }
    return true;
  }
  /** Renders the `Form` fields inside the <form> | `tagName` or `_internalFormWrapper`, rendering any errors if
   * needed along with the submit button or any children of the form.
   */;
  _proto.render = function render() {
    var _this$props6 = this.props,
      children = _this$props6.children,
      id = _this$props6.id,
      idPrefix = _this$props6.idPrefix,
      idSeparator = _this$props6.idSeparator,
      _this$props6$classNam = _this$props6.className,
      className = _this$props6$classNam === void 0 ? '' : _this$props6$classNam,
      tagName = _this$props6.tagName,
      name = _this$props6.name,
      method = _this$props6.method,
      target = _this$props6.target,
      action = _this$props6.action,
      autoComplete = _this$props6.autoComplete,
      enctype = _this$props6.enctype,
      acceptcharset = _this$props6.acceptcharset,
      _this$props6$noHtml5V = _this$props6.noHtml5Validate,
      noHtml5Validate = _this$props6$noHtml5V === void 0 ? false : _this$props6$noHtml5V,
      _this$props6$disabled = _this$props6.disabled,
      disabled = _this$props6$disabled === void 0 ? false : _this$props6$disabled,
      _this$props6$readonly = _this$props6.readonly,
      readonly = _this$props6$readonly === void 0 ? false : _this$props6$readonly,
      formContext = _this$props6.formContext,
      _this$props6$showErro = _this$props6.showErrorList,
      showErrorList = _this$props6$showErro === void 0 ? 'top' : _this$props6$showErro,
      _internalFormWrapper = _this$props6._internalFormWrapper;
    var _this$state4 = this.state,
      schema = _this$state4.schema,
      uiSchema = _this$state4.uiSchema,
      formData = _this$state4.formData,
      errorSchema = _this$state4.errorSchema,
      idSchema = _this$state4.idSchema;
    var registry = this.getRegistry();
    var _SchemaField = registry.fields.SchemaField;
    var SubmitButton = registry.templates.ButtonTemplates.SubmitButton;
    // The `semantic-ui` and `material-ui` themes have `_internalFormWrapper`s that take an `as` prop that is the
    // PropTypes.elementType to use for the inner tag, so we'll need to pass `tagName` along if it is provided.
    // NOTE, the `as` prop is native to `semantic-ui` and is emulated in the `material-ui` theme
    var as = _internalFormWrapper ? tagName : undefined;
    var FormTag = _internalFormWrapper || tagName || 'form';
    return jsxs(FormTag, {
      className: className ? className : 'rjsf',
      id: id,
      name: name,
      method: method,
      target: target,
      action: action,
      autoComplete: autoComplete,
      encType: enctype,
      acceptCharset: acceptcharset,
      noValidate: noHtml5Validate,
      onSubmit: this.onSubmit,
      as: as,
      ref: this.formElement,
      children: [showErrorList === 'top' && this.renderErrors(registry), jsx(_SchemaField, {
        name: '',
        schema: schema,
        uiSchema: uiSchema,
        errorSchema: errorSchema,
        idSchema: idSchema,
        idPrefix: idPrefix,
        idSeparator: idSeparator,
        formContext: formContext,
        formData: formData,
        onChange: this.onChange,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        registry: registry,
        disabled: disabled,
        readonly: readonly
      }), children ? children : jsx(SubmitButton, {
        uiSchema: uiSchema,
        registry: registry
      }), showErrorList === 'bottom' && this.renderErrors(registry)]
    });
  };
  return Form;
}(Component);

var _excluded = ["fields", "widgets", "templates"];
/** A Higher-Order component that creates a wrapper around a `Form` with the overrides from the `WithThemeProps` */
function withTheme(themeProps) {
  return /*#__PURE__*/forwardRef(function (_ref, ref) {
    var _themeProps$templates, _templates;
    var fields = _ref.fields,
      widgets = _ref.widgets,
      templates = _ref.templates,
      directProps = _objectWithoutPropertiesLoose(_ref, _excluded);
    fields = _extends({}, themeProps === null || themeProps === void 0 ? void 0 : themeProps.fields, fields);
    widgets = _extends({}, themeProps === null || themeProps === void 0 ? void 0 : themeProps.widgets, widgets);
    templates = _extends({}, themeProps === null || themeProps === void 0 ? void 0 : themeProps.templates, templates, {
      ButtonTemplates: _extends({}, themeProps === null || themeProps === void 0 ? void 0 : (_themeProps$templates = themeProps.templates) === null || _themeProps$templates === void 0 ? void 0 : _themeProps$templates.ButtonTemplates, (_templates = templates) === null || _templates === void 0 ? void 0 : _templates.ButtonTemplates)
    });
    return jsx(Form, _extends({}, themeProps, directProps, {
      fields: fields,
      widgets: widgets,
      templates: templates,
      ref: ref
    }));
  });
}

export { Form as default, getDefaultRegistry, withTheme };
//# sourceMappingURL=core.esm.js.map
