"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTarballName = extractTarballName;
exports.getLatest = getLatest;
exports.mergeVersions = mergeVersions;
exports.semverSort = semverSort;
var _semver = _interopRequireDefault(require("semver"));
var _url = require("url");
var _constants = require("./constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Extract the tarball name from a registry dist url
 * 'https://registry.npmjs.org/test/-/test-0.0.2.tgz'
 * @param tarball tarball url
 * @returns tarball filename
 */
function extractTarballName(tarball) {
  const urlObject = new _url.URL(tarball);
  const filename = urlObject.pathname.replace(/^.*\//, '');
  return filename;
}

/**
 * Function filters out bad semver versions and sorts the array.
 * @return {Array} sorted Array
 */
function semverSort(listVersions) {
  return listVersions.filter(function (x) {
    if (!_semver.default.parse(x, true)) {
      return false;
    }
    return true;
  }).sort(_semver.default.compareLoose).map(String);
}

/**
 * Get the latest publihsed version of a package.
 * @param package metadata
 **/
function getLatest(pkg) {
  var _pkg$DIST_TAGS;
  const listVersions = Object.keys(pkg.versions);
  if (listVersions.length < 1) {
    throw Error('cannot get lastest version of none');
  }
  const versions = semverSort(listVersions);
  const latest = (_pkg$DIST_TAGS = pkg[_constants.DIST_TAGS]) !== null && _pkg$DIST_TAGS !== void 0 && _pkg$DIST_TAGS.latest ? pkg[_constants.DIST_TAGS].latest : versions[0];
  return latest;
}

/**
 * Function gets a local info and an info from uplinks and tries to merge it
 exported for unit tests only.
  * @param {*} local
  * @param {*} upstream
  * @param {*} config sds
  * @deprecated use @verdaccio/storage mergeVersions method
  */
// @deprecated
function mergeVersions(local, upstream) {
  // copy new versions to a cache
  // NOTE: if a certain version was updated, we can't refresh it reliably
  for (const i in upstream.versions) {
    if (typeof local.versions[i] === 'undefined') {
      local.versions[i] = upstream.versions[i];
    }
  }
  for (const i in upstream[_constants.DIST_TAGS]) {
    if (local[_constants.DIST_TAGS][i] !== upstream[_constants.DIST_TAGS][i]) {
      if (!local[_constants.DIST_TAGS][i] || _semver.default.lte(local[_constants.DIST_TAGS][i], upstream[_constants.DIST_TAGS][i])) {
        local[_constants.DIST_TAGS][i] = upstream[_constants.DIST_TAGS][i];
      }
      if (i === 'latest' && local[_constants.DIST_TAGS][i] === upstream[_constants.DIST_TAGS][i]) {
        // if remote has more fresh package, we should borrow its readme
        local.readme = upstream.readme;
      }
    }
  }
}
//# sourceMappingURL=pkg-utils.js.map