import { Manifest } from '@verdaccio/types';
/**
 * Extract the tarball name from a registry dist url
 * 'https://registry.npmjs.org/test/-/test-0.0.2.tgz'
 * @param tarball tarball url
 * @returns tarball filename
 */
export declare function extractTarballName(tarball: string): any;
/**
 * Function filters out bad semver versions and sorts the array.
 * @return {Array} sorted Array
 */
export declare function semverSort(listVersions: string[]): string[];
/**
 * Get the latest publihsed version of a package.
 * @param package metadata
 **/
export declare function getLatest(pkg: Manifest): string;
/**
 * Function gets a local info and an info from uplinks and tries to merge it
 exported for unit tests only.
  * @param {*} local
  * @param {*} upstream
  * @param {*} config sds
  * @deprecated use @verdaccio/storage mergeVersions method
  */
export declare function mergeVersions(local: Manifest, upstream: Manifest): void;
