"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Files = void 0;
exports.createTempFolder = createTempFolder;
exports.createTempStorageFolder = createTempStorageFolder;
var _fs = _interopRequireDefault(require("fs"));
var _os = _interopRequireDefault(require("os"));
var _path = _interopRequireDefault(require("path"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const Files = {
  DatabaseName: '.verdaccio-db.json'
};
exports.Files = Files;
const {
  mkdir,
  mkdtemp
} = _fs.default.promises ? _fs.default.promises : require('fs/promises');

/**
 * Create a temporary folder.
 * @param prefix The prefix of the folder name.
 * @returns string
 */
async function createTempFolder(prefix) {
  return await mkdtemp(_path.default.join(_os.default.tmpdir(), prefix));
}

/**
 * Create temporary folder for an asset.
 * @param prefix
 * @param folder name
 * @returns
 */
async function createTempStorageFolder(prefix, folder = 'storage') {
  const tempFolder = await createTempFolder(prefix);
  const storageFolder = _path.default.join(tempFolder, folder);
  await mkdir(storageFolder);
  return storageFolder;
}
//# sourceMappingURL=file-utils.js.map