import { HttpError } from 'http-errors';
export declare const API_ERROR: {
    PASSWORD_SHORT: string;
    MUST_BE_LOGGED: string;
    PLUGIN_ERROR: string;
    CONFIG_BAD_FORMAT: string;
    BAD_USERNAME_PASSWORD: string;
    NO_PACKAGE: string;
    PACKAGE_CANNOT_BE_ADDED: string;
    BAD_DATA: string;
    NOT_ALLOWED: string;
    NOT_ALLOWED_PUBLISH: string;
    INTERNAL_SERVER_ERROR: string;
    UNKNOWN_ERROR: string;
    NOT_PACKAGE_UPLINK: string;
    UPLINK_OFFLINE_PUBLISH: string;
    UPLINK_OFFLINE: string;
    NOT_MODIFIED_NO_DATA: string;
    CONTENT_MISMATCH: string;
    NOT_FILE_UPLINK: string;
    MAX_USERS_REACHED: string;
    VERSION_NOT_EXIST: string;
    NO_SUCH_FILE: string;
    UNSUPORTED_REGISTRY_CALL: string;
    FILE_NOT_FOUND: string;
    REGISTRATION_DISABLED: string;
    UNAUTHORIZED_ACCESS: string;
    BAD_STATUS_CODE: string;
    PACKAGE_EXIST: string;
    BAD_AUTH_HEADER: string;
    WEB_DISABLED: string;
    DEPRECATED_BASIC_HEADER: string;
    BAD_FORMAT_USER_GROUP: string;
    RESOURCE_UNAVAILABLE: string;
    BAD_PACKAGE_DATA: string;
    USERNAME_PASSWORD_REQUIRED: string;
    USERNAME_ALREADY_REGISTERED: string;
};
export declare const SUPPORT_ERRORS: {
    PLUGIN_MISSING_INTERFACE: string;
    TFA_DISABLED: string;
    STORAGE_NOT_IMPLEMENT: string;
    PARAMETERS_NOT_VALID: string;
};
export declare const APP_ERROR: {
    CONFIG_NOT_VALID: string;
    PROFILE_ERROR: string;
    PASSWORD_VALIDATION: string;
};
export type VerdaccioError = HttpError & {
    code: number;
};
export declare function getConflict(message?: string): VerdaccioError;
export declare function getBadData(customMessage?: string): VerdaccioError;
export declare function getBadRequest(customMessage: string): VerdaccioError;
export declare function getInternalError(customMessage?: string): VerdaccioError;
export declare function getUnauthorized(message?: string): VerdaccioError;
export declare function getForbidden(message?: string): VerdaccioError;
export declare function getServiceUnavailable(message?: string): VerdaccioError;
export declare function getNotFound(customMessage?: string): VerdaccioError;
export declare function getCode(statusCode: number, customMessage: string): VerdaccioError;
