"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERS = exports.TOKEN_BEARER = exports.TOKEN_BASIC = exports.TIME_EXPIRATION_24H = exports.TIME_EXPIRATION_1H = exports.ROLES = exports.PACKAGE_ACCESS = exports.LOG_VERDACCIO_ERROR = exports.LOG_VERDACCIO_BYTES = exports.LOG_STATUS_MESSAGE = exports.LATEST = exports.HTTP_STATUS = exports.HEADER_TYPE = exports.HEADERS = exports.ERROR_CODE = exports.DIST_TAGS = exports.DEFAULT_USER = exports.DEFAULT_PASSWORD_VALIDATION = exports.CHARACTER_ENCODING = exports.API_MESSAGE = void 0;
var _httpStatusCodes = _interopRequireDefault(require("http-status-codes"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const DEFAULT_PASSWORD_VALIDATION = /.{3}$/;
exports.DEFAULT_PASSWORD_VALIDATION = DEFAULT_PASSWORD_VALIDATION;
const TIME_EXPIRATION_24H = '24h';
exports.TIME_EXPIRATION_24H = TIME_EXPIRATION_24H;
const TIME_EXPIRATION_1H = '1h';
exports.TIME_EXPIRATION_1H = TIME_EXPIRATION_1H;
const DIST_TAGS = 'dist-tags';
exports.DIST_TAGS = DIST_TAGS;
const LATEST = 'latest';
exports.LATEST = LATEST;
const USERS = 'users';
exports.USERS = USERS;
const DEFAULT_USER = 'Anonymous';
exports.DEFAULT_USER = DEFAULT_USER;
const HEADER_TYPE = {
  CONTENT_ENCODING: 'content-encoding',
  CONTENT_TYPE: 'content-type',
  CONTENT_LENGTH: 'content-length',
  ACCEPT_ENCODING: 'accept-encoding'
};
exports.HEADER_TYPE = HEADER_TYPE;
const CHARACTER_ENCODING = {
  UTF8: 'utf8'
};

// @deprecated use Bearer instead
exports.CHARACTER_ENCODING = CHARACTER_ENCODING;
const TOKEN_BASIC = 'Basic';
exports.TOKEN_BASIC = TOKEN_BASIC;
const TOKEN_BEARER = 'Bearer';
exports.TOKEN_BEARER = TOKEN_BEARER;
const HEADERS = {
  ACCEPT: 'Accept',
  ACCEPT_ENCODING: 'Accept-Encoding',
  USER_AGENT: 'User-Agent',
  JSON: 'application/json',
  CONTENT_TYPE: 'Content-type',
  CONTENT_LENGTH: 'content-length',
  TEXT_PLAIN: 'text/plain',
  TEXT_PLAIN_UTF8: 'text/plain; charset=utf-8',
  TEXT_HTML_UTF8: 'text/html; charset=utf-8',
  TEXT_HTML: 'text/html',
  AUTHORIZATION: 'authorization',
  CACHE_CONTROL: 'Cache-Control',
  // only set with proxy that setup HTTPS
  // https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Proto
  FORWARDED_PROTO: 'X-Forwarded-Proto',
  FORWARDED_FOR: 'X-Forwarded-For',
  FRAMES_OPTIONS: 'X-Frame-Options',
  CSP: 'Content-Security-Policy',
  CTO: 'X-Content-Type-Options',
  XSS: 'X-XSS-Protection',
  NONE_MATCH: 'If-None-Match',
  ETAG: 'ETag',
  JSON_CHARSET: 'application/json; charset=utf-8',
  JSON_INSTALL_CHARSET: 'application/vnd.npm.install-v1+json; charset=utf-8',
  OCTET_STREAM: 'application/octet-stream; charset=utf-8',
  TEXT_CHARSET: 'text/plain; charset=utf-8',
  WWW_AUTH: 'WWW-Authenticate',
  GZIP: 'gzip'
};
exports.HEADERS = HEADERS;
const HTTP_STATUS = {
  OK: _httpStatusCodes.default.OK,
  CREATED: _httpStatusCodes.default.CREATED,
  MULTIPLE_CHOICES: _httpStatusCodes.default.MULTIPLE_CHOICES,
  NOT_MODIFIED: _httpStatusCodes.default.NOT_MODIFIED,
  BAD_REQUEST: _httpStatusCodes.default.BAD_REQUEST,
  UNAUTHORIZED: _httpStatusCodes.default.UNAUTHORIZED,
  FORBIDDEN: _httpStatusCodes.default.FORBIDDEN,
  NOT_FOUND: _httpStatusCodes.default.NOT_FOUND,
  CONFLICT: _httpStatusCodes.default.CONFLICT,
  NOT_IMPLEMENTED: _httpStatusCodes.default.NOT_IMPLEMENTED,
  UNSUPPORTED_MEDIA: _httpStatusCodes.default.UNSUPPORTED_MEDIA_TYPE,
  BAD_DATA: _httpStatusCodes.default.UNPROCESSABLE_ENTITY,
  INTERNAL_ERROR: _httpStatusCodes.default.INTERNAL_SERVER_ERROR,
  SERVICE_UNAVAILABLE: _httpStatusCodes.default.SERVICE_UNAVAILABLE,
  LOOP_DETECTED: 508
};
exports.HTTP_STATUS = HTTP_STATUS;
const ERROR_CODE = {
  token_required: 'token is required'
};
exports.ERROR_CODE = ERROR_CODE;
const API_MESSAGE = {
  PKG_CREATED: 'created new package',
  PKG_CHANGED: 'package changed',
  PKG_REMOVED: 'package removed',
  PKG_PUBLISHED: 'package published',
  TARBALL_UPLOADED: 'tarball uploaded successfully',
  TARBALL_REMOVED: 'tarball removed',
  TAG_UPDATED: 'tags updated',
  TAG_REMOVED: 'tag removed',
  TAG_ADDED: 'package tagged',
  OK: 'ok',
  LOGGED_OUT: 'Logged out'
};
exports.API_MESSAGE = API_MESSAGE;
const LOG_STATUS_MESSAGE = "@{status}, user: @{user}(@{remoteIP}), req: '@{request.method} @{request.url}'";
exports.LOG_STATUS_MESSAGE = LOG_STATUS_MESSAGE;
const LOG_VERDACCIO_ERROR = `${LOG_STATUS_MESSAGE}, error: @{!error}`;
exports.LOG_VERDACCIO_ERROR = LOG_VERDACCIO_ERROR;
const LOG_VERDACCIO_BYTES = `${LOG_STATUS_MESSAGE}, bytes: @{bytes.in}/@{bytes.out}`;
exports.LOG_VERDACCIO_BYTES = LOG_VERDACCIO_BYTES;
const ROLES = {
  $ALL: '$all',
  ALL: 'all',
  $AUTH: '$authenticated',
  $ANONYMOUS: '$anonymous',
  DEPRECATED_ALL: '@all',
  DEPRECATED_AUTH: '@authenticated',
  DEPRECATED_ANONYMOUS: '@anonymous'
};
exports.ROLES = ROLES;
const PACKAGE_ACCESS = {
  SCOPE: '@*/*',
  ALL: '**'
};
exports.PACKAGE_ACCESS = PACKAGE_ACCESS;
//# sourceMappingURL=constants.js.map