export declare const DEFAULT_PASSWORD_VALIDATION: RegExp;
export declare const TIME_EXPIRATION_24H = "24h";
export declare const TIME_EXPIRATION_1H = "1h";
export declare const DIST_TAGS = "dist-tags";
export declare const LATEST = "latest";
export declare const USERS = "users";
export declare const DEFAULT_USER = "Anonymous";
export declare const HEADER_TYPE: {
    CONTENT_ENCODING: string;
    CONTENT_TYPE: string;
    CONTENT_LENGTH: string;
    ACCEPT_ENCODING: string;
};
export declare const CHARACTER_ENCODING: {
    UTF8: string;
};
export declare const TOKEN_BASIC = "Basic";
export declare const TOKEN_BEARER = "Bearer";
export declare const HEADERS: {
    ACCEPT: string;
    ACCEPT_ENCODING: string;
    USER_AGENT: string;
    JSON: string;
    CONTENT_TYPE: string;
    CONTENT_LENGTH: string;
    TEXT_PLAIN: string;
    TEXT_PLAIN_UTF8: string;
    TEXT_HTML_UTF8: string;
    TEXT_HTML: string;
    AUTHORIZATION: string;
    CACHE_CONTROL: string;
    FORWARDED_PROTO: string;
    FORWARDED_FOR: string;
    FRAMES_OPTIONS: string;
    CSP: string;
    CTO: string;
    XSS: string;
    NONE_MATCH: string;
    ETAG: string;
    JSON_CHARSET: string;
    JSON_INSTALL_CHARSET: string;
    OCTET_STREAM: string;
    TEXT_CHARSET: string;
    WWW_AUTH: string;
    GZIP: string;
};
export declare const HTTP_STATUS: {
    OK: number;
    CREATED: number;
    MULTIPLE_CHOICES: number;
    NOT_MODIFIED: number;
    BAD_REQUEST: number;
    UNAUTHORIZED: number;
    FORBIDDEN: number;
    NOT_FOUND: number;
    CONFLICT: number;
    NOT_IMPLEMENTED: number;
    UNSUPPORTED_MEDIA: number;
    BAD_DATA: number;
    INTERNAL_ERROR: number;
    SERVICE_UNAVAILABLE: number;
    LOOP_DETECTED: number;
};
export declare const ERROR_CODE: {
    token_required: string;
};
export declare const API_MESSAGE: {
    PKG_CREATED: string;
    PKG_CHANGED: string;
    PKG_REMOVED: string;
    PKG_PUBLISHED: string;
    TARBALL_UPLOADED: string;
    TARBALL_REMOVED: string;
    TAG_UPDATED: string;
    TAG_REMOVED: string;
    TAG_ADDED: string;
    OK: string;
    LOGGED_OUT: string;
};
export declare const LOG_STATUS_MESSAGE = "@{status}, user: @{user}(@{remoteIP}), req: '@{request.method} @{request.url}'";
export declare const LOG_VERDACCIO_ERROR: string;
export declare const LOG_VERDACCIO_BYTES: string;
export declare const ROLES: {
    $ALL: string;
    ALL: string;
    $AUTH: string;
    $ANONYMOUS: string;
    DEPRECATED_ALL: string;
    DEPRECATED_AUTH: string;
    DEPRECATED_ANONYMOUS: string;
};
export declare const PACKAGE_ACCESS: {
    SCOPE: string;
    ALL: string;
};
