// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { StackedLayout, Widget } from '@lumino/widgets';
import { CodeEditor } from './editor';
import { CodeEditorWrapper } from './widget';
export class CodeViewerWidget extends Widget {
    /**
     * Construct a new code viewer widget.
     */
    constructor(options) {
        var _a;
        super();
        this.model = options.model;
        const editorWidget = new CodeEditorWrapper({
            factory: options.factory,
            model: this.model,
            editorOptions: {
                ...options.editorOptions,
                config: { ...(_a = options.editorOptions) === null || _a === void 0 ? void 0 : _a.config, readOnly: true }
            }
        });
        this.editor = editorWidget.editor;
        const layout = (this.layout = new StackedLayout());
        layout.addWidget(editorWidget);
    }
    static createCodeViewer(options) {
        const { content, mimeType, ...others } = options;
        const model = new CodeEditor.Model({
            mimeType
        });
        model.sharedModel.setSource(content);
        const widget = new CodeViewerWidget({ ...others, model });
        widget.disposed.connect(() => {
            model.dispose();
        });
        return widget;
    }
    get content() {
        return this.model.sharedModel.getSource();
    }
    get mimeType() {
        return this.model.mimeType;
    }
}
//# sourceMappingURL=viewer.js.map