"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOKEN_VALID_LENGTH = void 0;
exports.createTarballHash = createTarballHash;
exports.defaultTarballHashAlgorithm = void 0;
exports.generateRandomHexString = generateRandomHexString;
exports.generateRandomSecretKey = generateRandomSecretKey;
exports.stringToMD5 = stringToMD5;
var _crypto = require("crypto");
const defaultTarballHashAlgorithm = 'sha1';

/**
 *
 * @returns
 */
exports.defaultTarballHashAlgorithm = defaultTarballHashAlgorithm;
function createTarballHash(algorithm = defaultTarballHashAlgorithm) {
  return (0, _crypto.createHash)(algorithm);
}

/**
 * Express doesn't do ETAGS with requests <= 1024b
 * we use md5 here, it works well on 1k+ bytes, but with fewer data
 * could improve performance using crc32 after benchmarks.
 * @param {Object} data
 * @return {String}
 */
function stringToMD5(data) {
  return (0, _crypto.createHash)('md5').update(data).digest('hex');
}

/**
 *
 * @param length
 * @returns
 */
function generateRandomHexString(length = 8) {
  return (0, _crypto.pseudoRandomBytes)(length).toString('hex');
}
const TOKEN_VALID_LENGTH = 32;

/**
 * Generate a secret of 32 characters.
 */
exports.TOKEN_VALID_LENGTH = TOKEN_VALID_LENGTH;
function generateRandomSecretKey() {
  return (0, _crypto.randomBytes)(TOKEN_VALID_LENGTH).toString('base64').substring(0, TOKEN_VALID_LENGTH);
}
//# sourceMappingURL=utils.js.map