/// <reference types="node" />
/// <reference types="node" />
import { Hash } from 'crypto';
export declare const defaultTarballHashAlgorithm = "sha1";
/**
 *
 * @returns
 */
export declare function createTarballHash(algorithm?: string): Hash;
/**
 * Express doesn't do ETAGS with requests <= 1024b
 * we use md5 here, it works well on 1k+ bytes, but with fewer data
 * could improve performance using crc32 after benchmarks.
 * @param {Object} data
 * @return {String}
 */
export declare function stringToMD5(data: Buffer | string): string;
/**
 *
 * @param length
 * @returns
 */
export declare function generateRandomHexString(length?: number): string;
export declare const TOKEN_VALID_LENGTH = 32;
/**
 * Generate a secret of 32 characters.
 */
export declare function generateRandomSecretKey(): string;
