"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aesDecrypt = aesDecrypt;
exports.aesEncrypt = aesEncrypt;
exports.defaultAlgorithm = void 0;
var _crypto = require("crypto");
var _debug = _interopRequireDefault(require("debug"));
var _config = require("@verdaccio/config");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:auth:token:legacy');
const defaultAlgorithm = process.env.VERDACCIO_LEGACY_ALGORITHM || 'aes-256-ctr';
exports.defaultAlgorithm = defaultAlgorithm;
const inputEncoding = 'utf8';
const outputEncoding = 'hex';
// Must be 256 bits (32 characters)
// https://stackoverflow.com/questions/50963160/invalid-key-length-in-crypto-createcipheriv#50963356
const VERDACCIO_LEGACY_ENCRYPTION_KEY = process.env.VERDACCIO_LEGACY_ENCRYPTION_KEY;
function aesEncrypt(value, key) {
  // https://nodejs.org/api/crypto.html#crypto_crypto_createcipher_algorithm_password_options
  // https://www.grainger.xyz/posts/changing-from-cipher-to-cipheriv
  debug('encrypt %o', value);
  debug('algorithm %o', defaultAlgorithm);
  // IV must be a buffer of length 16
  const iv = Buffer.from((0, _crypto.randomBytes)(16));
  const secretKey = VERDACCIO_LEGACY_ENCRYPTION_KEY || key;
  const isKeyValid = (secretKey === null || secretKey === void 0 ? void 0 : secretKey.length) === _config.TOKEN_VALID_LENGTH;
  debug('length secret key %o', secretKey === null || secretKey === void 0 ? void 0 : secretKey.length);
  debug('is valid secret %o', isKeyValid);
  if (!value || !secretKey || !isKeyValid) {
    return;
  }
  const cipher = (0, _crypto.createCipheriv)(defaultAlgorithm, secretKey, iv);
  let encrypted = cipher.update(value, inputEncoding, outputEncoding);
  // @ts-ignore
  encrypted += cipher.final(outputEncoding);
  const token = `${iv.toString('hex')}:${encrypted.toString()}`;
  debug('token generated successfully');
  return Buffer.from(token).toString('base64');
}
function aesDecrypt(value, key) {
  try {
    const buff = Buffer.from(value, 'base64');
    const textParts = buff.toString().split(':');

    // extract the IV from the first half of the value
    // @ts-ignore
    const IV = Buffer.from(textParts.shift(), outputEncoding);
    // extract the encrypted text without the IV
    const encryptedText = Buffer.from(textParts.join(':'), outputEncoding);
    const secretKey = VERDACCIO_LEGACY_ENCRYPTION_KEY || key;
    // decipher the string
    const decipher = (0, _crypto.createDecipheriv)(defaultAlgorithm, secretKey, IV);
    // FIXME: fix type here should allow Buffer
    let decrypted = decipher.update(encryptedText, outputEncoding, inputEncoding);
    decrypted += decipher.final(inputEncoding);
    debug('token decrypted successfully');
    return decrypted.toString();
  } catch (_) {
    return;
  }
}
//# sourceMappingURL=signature.js.map