"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOKEN_VALID_LENGTH_DEPRECATED = void 0;
exports.aesDecryptDeprecated = aesDecryptDeprecated;
exports.aesEncryptDeprecated = aesEncryptDeprecated;
exports.defaultTarballHashAlgorithm = exports.defaultAlgorithm = void 0;
exports.generateRandomSecretKeyDeprecated = generateRandomSecretKeyDeprecated;
var _crypto = require("crypto");
var _utils = require("../utils");
const defaultAlgorithm = 'aes192';
exports.defaultAlgorithm = defaultAlgorithm;
const defaultTarballHashAlgorithm = 'sha1';

/**
 *
 * @param buf
 * @param secret
 * @returns
 */
exports.defaultTarballHashAlgorithm = defaultTarballHashAlgorithm;
function aesEncryptDeprecated(buf, secret) {
  // deprecated (it will be removed in Verdaccio 6), it is a breaking change
  // https://nodejs.org/api/crypto.html#crypto_crypto_createcipher_algorithm_password_options
  // https://www.grainger.xyz/changing-from-cipher-to-cipheriv/
  const c = (0, _crypto.createCipher)(defaultAlgorithm, secret);
  const b1 = c.update(buf);
  const b2 = c.final();
  return Buffer.concat([b1, b2]);
}

/**
 *
 * @param buf
 * @param secret
 * @returns
 */
function aesDecryptDeprecated(buf, secret) {
  try {
    // https://nodejs.org/api/crypto.html#crypto_crypto_createdecipher_algorithm_password_options
    // https://www.grainger.xyz/changing-from-cipher-to-cipheriv/
    const c = (0, _crypto.createDecipher)(defaultAlgorithm, secret);
    const b1 = c.update(buf);
    const b2 = c.final();
    return Buffer.concat([b1, b2]);
  } catch (_) {
    return Buffer.alloc(0);
  }
}
const TOKEN_VALID_LENGTH_DEPRECATED = 64;

/**
 * Generate a secret key of 64 characters.
 */
exports.TOKEN_VALID_LENGTH_DEPRECATED = TOKEN_VALID_LENGTH_DEPRECATED;
function generateRandomSecretKeyDeprecated() {
  return (0, _utils.generateRandomHexString)(6);
}
//# sourceMappingURL=index.js.map