"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.signPayload = signPayload;
exports.verifyPayload = verifyPayload;
var _debug = _interopRequireDefault(require("debug"));
var _jsonwebtoken = _interopRequireDefault(require("jsonwebtoken"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:auth:token:jwt');
/**
 * Sign the payload and return JWT
 * https://github.com/auth0/node-jsonwebtoken#jwtsignpayload-secretorprivatekey-options-callback
 * @param payload
 * @param secretOrPrivateKey
 * @param options
 */
async function signPayload(payload, secretOrPrivateKey, options = {}) {
  return new Promise(function (resolve, reject) {
    debug('sign jwt token');
    return _jsonwebtoken.default.sign(payload, secretOrPrivateKey,
    // FIXME: upgrade to the latest library and types
    // @ts-ignore
    {
      // 1 === 1ms (one millisecond)
      notBefore: '1',
      // Make sure the time will not rollback :)
      ...options
    }, (error, token) => {
      debug('error on sign jwt token');
      return error ? reject(error) : resolve(token);
    });
  });
}
function verifyPayload(token, secretOrPrivateKey) {
  debug('verify jwt token');
  return _jsonwebtoken.default.verify(token, secretOrPrivateKey);
}
//# sourceMappingURL=jwt-token.js.map