import { JWTSignOptions, RemoteUser } from '@verdaccio/types';
/**
 * Sign the payload and return JWT
 * https://github.com/auth0/node-jsonwebtoken#jwtsignpayload-secretorprivatekey-options-callback
 * @param payload
 * @param secretOrPrivateKey
 * @param options
 */
export declare function signPayload(payload: RemoteUser, secretOrPrivateKey: string, options?: JWTSignOptions): Promise<string>;
export declare function verifyPayload(token: string, secretOrPrivateKey: string): RemoteUser;
