/**
 * @packageDocumentation
 * @module running-extension
 */
import { JupyterFrontEndPlugin } from '@jupyterlab/application';
import { IRunningSessionManagers } from '@jupyterlab/running';
/**
 * The command IDs used by the running plugin.
 */
export declare namespace CommandIDs {
    const kernelNewConsole = "running:kernel-new-console";
    const kernelNewNotebook = "running:kernel-new-notebook";
    const kernelOpenSession = "running:kernel-open-session";
    const kernelShutDown = "running:kernel-shut-down";
    const showPanel = "running:show-panel";
}
/**
 * The default running sessions extension.
 */
declare const plugin: JupyterFrontEndPlugin<IRunningSessionManagers>;
/**
 * Export the plugin as default.
 */
export default plugin;
