import { Base16Theme } from 'base16';
import * as CSS from 'csstype';
export interface Styling {
    className?: string;
    style?: CSS.Properties<string | number>;
}
export declare type StylingValueFunction = (styling: Styling, ...rest: unknown[]) => Partial<Styling>;
export declare type StylingValue = string | CSS.Properties<string | number> | StylingValueFunction;
export declare type StylingConfig = {
    extend?: string | Base16Theme | StylingValue;
} & {
    [name: string]: StylingValue | string | Base16Theme;
};
export declare type Theme = string | Base16Theme | StylingConfig;
export declare type StylingFunction = (keys: (string | false | undefined) | (string | false | undefined)[], ...rest: unknown[]) => Styling;
