import { IThemeManager } from '@jupyterlab/apputils';
import { IEditorServices } from '@jupyterlab/codeeditor';
import { ITranslator } from '@jupyterlab/translation';
import { SidePanel } from '@jupyterlab/ui-components';
import { Widget } from '@lumino/widgets';
import { Breakpoints as BreakpointsPanel } from './panels/breakpoints';
import { Callstack as CallstackPanel } from './panels/callstack';
import { Sources as SourcesPanel } from './panels/sources';
import { KernelSources as KernelSourcesPanel } from './panels/kernelSources';
import { Variables as VariablesPanel } from './panels/variables';
import { IDebugger } from './tokens';
/**
 * A debugger sidebar.
 */
export declare class DebuggerSidebar extends SidePanel {
    /**
     * Instantiate a new Debugger.Sidebar
     *
     * @param options The instantiation options for a Debugger.Sidebar
     */
    constructor(options: DebuggerSidebar.IOptions);
    /**
     * The variables widget.
     */
    readonly variables: VariablesPanel;
    /**
     * The callstack widget.
     */
    readonly callstack: CallstackPanel;
    /**
     * The breakpoints widget.
     */
    readonly breakpoints: BreakpointsPanel;
    /**
     * The sources widget.
     */
    readonly sources: SourcesPanel;
    readonly kernelSources: KernelSourcesPanel;
}
/**
 * A namespace for DebuggerSidebar statics
 */
export declare namespace DebuggerSidebar {
    /**
     * Instantiation options for `DebuggerSidebar`.
     */
    interface IOptions {
        /**
         * The debug service.
         */
        service: IDebugger;
        /**
         * The callstack toolbar commands.
         */
        callstackCommands: CallstackPanel.ICommands;
        /**
         * The callstack toolbar commands.
         */
        breakpointsCommands: BreakpointsPanel.ICommands;
        /**
         * The editor services.
         */
        editorServices: IEditorServices;
        /**
         * An optional application theme manager to detect theme changes.
         */
        themeManager?: IThemeManager | null;
        /**
         * An optional application language translator.
         */
        translator?: ITranslator;
    }
    /**
     * The header for a debugger sidebar.
     */
    class Header extends Widget {
        /**
         * Instantiate a new sidebar header.
         */
        constructor();
    }
}
