/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
import { nullTranslator } from '@jupyterlab/translation';
import { PanelWithToolbar, ToolbarButton } from '@jupyterlab/ui-components';
import { viewBreakpointIcon } from '../../icons';
import { SourcePathComponent } from './sourcepath';
import { SourcesBody } from './body';
import { ReactWidget } from '@jupyterlab/ui-components';
import React from 'react';
/**
 * A Panel that shows a preview of the source code while debugging.
 */
export class Sources extends PanelWithToolbar {
    /**
     * Instantiate a new Sources preview Panel.
     *
     * @param options The Sources instantiation options.
     */
    constructor(options) {
        var _a;
        super();
        const { model, service, editorServices } = options;
        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : nullTranslator).load('jupyterlab');
        this.title.label = trans.__('Source');
        this.toolbar.addClass('jp-DebuggerSources-header');
        const body = new SourcesBody({
            service,
            model,
            editorServices
        });
        this.toolbar.addItem('open', new ToolbarButton({
            icon: viewBreakpointIcon,
            onClick: () => model.open(),
            tooltip: trans.__('Open in the Main Area')
        }));
        const sourcePath = ReactWidget.create(React.createElement(SourcePathComponent, { model: model }));
        this.toolbar.addItem('sourcePath', sourcePath);
        this.addClass('jp-DebuggerSources-header');
        this.addWidget(body);
        this.addClass('jp-DebuggerSources');
    }
}
//# sourceMappingURL=index.js.map