// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { nullTranslator } from '@jupyterlab/translation';
import { showErrorMessage } from '@jupyterlab/apputils';
import { PanelWithToolbar, refreshIcon, searchIcon, ToolbarButton } from '@jupyterlab/ui-components';
import { KernelSourcesBody } from './body';
/**
 * A Panel that shows a preview of the source code while debugging.
 */
export class KernelSources extends PanelWithToolbar {
    /**
     * Instantiate a new Sources preview Panel.
     *
     * @param options The Sources instantiation options.
     */
    constructor(options) {
        var _a;
        super();
        const { model, service } = options;
        this._model = model;
        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : nullTranslator).load('jupyterlab');
        this.title.label = trans.__('Kernel Sources');
        this.toolbar.addClass('jp-DebuggerKernelSources-header');
        this._body = new KernelSourcesBody({
            service,
            model,
            translator: options.translator
        });
        this.toolbar.addItem('open-filter', new ToolbarButton({
            icon: searchIcon,
            onClick: async () => {
                this._body.toggleFilterbox();
            },
            tooltip: trans.__('Toggle search filter')
        }));
        this.toolbar.addItem('refresh', new ToolbarButton({
            icon: refreshIcon,
            onClick: () => {
                this._model.kernelSources = [];
                void service.displayModules().catch(reason => {
                    void showErrorMessage(trans.__('Fail to get kernel sources'), trans.__('Fail to get kernel sources:\n%2', reason));
                });
            },
            tooltip: trans.__('Refresh kernel sources')
        }));
        this.addClass('jp-DebuggerKernelSources-header');
        this.addWidget(this._body);
        this.addClass('jp-DebuggerKenelSources');
    }
    set filter(filter) {
        this._model.filter = filter;
    }
}
//# sourceMappingURL=index.js.map