// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import React from 'react';
import { openKernelSourceIcon } from '../../icons';
import { ReactWidget, ToolbarButtonComponent } from '@jupyterlab/ui-components';
import { showErrorMessage } from '@jupyterlab/apputils';
import { nullTranslator } from '@jupyterlab/translation';
import { KernelSourcesFilter } from './filter';
import { UseSignal } from '@jupyterlab/ui-components';
/**
 * The class name added to the filterbox node.
 */
const FILTERBOX_CLASS = 'jp-DebuggerKernelSource-filterBox';
/**
 * The class name added to hide the filterbox node.
 */
const FILTERBOX_HIDDEN_CLASS = 'jp-DebuggerKernelSource-filterBox-hidden';
/**
 * The body for a Sources Panel.
 */
export class KernelSourcesBody extends ReactWidget {
    /**
     * Instantiate a new Body for the KernelSourcesBody widget.
     *
     * @param options The instantiation options for a KernelSourcesBody.
     */
    constructor(options) {
        var _a;
        super();
        this._showFilter = false;
        this._model = options.model;
        this._debuggerService = options.service;
        this._trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : nullTranslator).load('jupyterlab');
        this.addClass('jp-DebuggerKernelSources-body');
    }
    render() {
        let filterClass = FILTERBOX_CLASS;
        if (!this._showFilter) {
            filterClass += ' ' + FILTERBOX_HIDDEN_CLASS;
        }
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { className: filterClass, key: 'filter' },
                React.createElement(KernelSourcesFilter, { model: this._model })),
            React.createElement(UseSignal, { signal: this._model.changed }, (_, kernelSources) => {
                const keymap = {};
                return (kernelSources !== null && kernelSources !== void 0 ? kernelSources : []).map(module => {
                    var _a;
                    const name = module.name;
                    const path = module.path;
                    const key = name + (keymap[name] = ((_a = keymap[name]) !== null && _a !== void 0 ? _a : 0) + 1).toString();
                    const button = (React.createElement(ToolbarButtonComponent, { key: key, icon: openKernelSourceIcon, label: name, tooltip: path, onClick: () => {
                            this._debuggerService
                                .getSource({
                                sourceReference: 0,
                                path: path
                            })
                                .then(source => {
                                this._model.open(source);
                            })
                                .catch(reason => {
                                void showErrorMessage(this._trans.__('Fail to get source'), this._trans.__("Fail to get '%1' source:\n%2", path, reason));
                            });
                        } }));
                    return button;
                });
            })));
    }
    /**
     * Show or hide the filter box.
     */
    toggleFilterbox() {
        this._showFilter = !this._showFilter;
        this.update();
    }
}
//# sourceMappingURL=body.js.map