import { ReactWidget } from '@jupyterlab/ui-components';
import { ITranslator } from '@jupyterlab/translation';
import { IDebugger } from '../../tokens';
/**
 * The body for a Sources Panel.
 */
export declare class KernelSourcesBody extends ReactWidget {
    /**
     * Instantiate a new Body for the KernelSourcesBody widget.
     *
     * @param options The instantiation options for a KernelSourcesBody.
     */
    constructor(options: KernelSourcesBody.IOptions);
    render(): JSX.Element;
    /**
     * Show or hide the filter box.
     */
    toggleFilterbox(): void;
    private _model;
    private _debuggerService;
    private _trans;
    private _showFilter;
}
/**
 * A namespace for SourcesBody `statics`.
 */
export declare namespace KernelSourcesBody {
    /**
     * Instantiation options for `Breakpoints`.
     */
    interface IOptions {
        /**
         * The debug service.
         */
        service: IDebugger;
        /**
         * The sources model.
         */
        model: IDebugger.Model.IKernelSources;
        /**
         * The application language translator
         */
        translator?: ITranslator;
    }
}
