// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { nullTranslator } from '@jupyterlab/translation';
import { CommandToolbarButton, PanelWithToolbar } from '@jupyterlab/ui-components';
import { CallstackBody } from './body';
/**
 * A Panel to show a callstack.
 */
export class Callstack extends PanelWithToolbar {
    /**
     * Instantiate a new Callstack Panel.
     *
     * @param options The instantiation options for a Callstack Panel.
     */
    constructor(options) {
        var _a;
        super(options);
        const { commands, model } = options;
        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : nullTranslator).load('jupyterlab');
        this.title.label = trans.__('Callstack');
        const body = new CallstackBody(model);
        this.toolbar.addItem('continue', new CommandToolbarButton({
            commands: commands.registry,
            id: commands.continue,
            label: ''
        }));
        this.toolbar.addItem('terminate', new CommandToolbarButton({
            commands: commands.registry,
            id: commands.terminate,
            label: ''
        }));
        this.toolbar.addItem('step-over', new CommandToolbarButton({
            commands: commands.registry,
            id: commands.next,
            label: ''
        }));
        this.toolbar.addItem('step-in', new CommandToolbarButton({
            commands: commands.registry,
            id: commands.stepIn,
            label: ''
        }));
        this.toolbar.addItem('step-out', new CommandToolbarButton({
            commands: commands.registry,
            id: commands.stepOut,
            label: ''
        }));
        this.toolbar.addItem('evaluate', new CommandToolbarButton({
            commands: commands.registry,
            id: commands.evaluate,
            label: ''
        }));
        this.addWidget(body);
        this.addClass('jp-DebuggerCallstack');
    }
}
//# sourceMappingURL=index.js.map