// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import * as React from 'react';
import { MenuSvg, ToolbarButton, ToolbarButtonComponent } from '@jupyterlab/ui-components';
const PAUSE_ON_EXCEPTION_CLASS = 'jp-debugger-pauseOnExceptions';
const PAUSE_ON_EXCEPTION_BUTTON_CLASS = 'jp-PauseOnExceptions';
const PAUSE_ON_EXCEPTION_MENU_CLASS = 'jp-PauseOnExceptions-menu';
/**
 * A button which display a menu on click, to select the filter.
 */
export class PauseOnExceptionsWidget extends ToolbarButton {
    /**
     * Constructor of the button.
     */
    constructor(props) {
        super();
        /**
         * open menu on click.
         */
        this.onclick = () => {
            this._menu.open(this.node.getBoundingClientRect().left, this.node.getBoundingClientRect().bottom);
        };
        this._menu = new PauseOnExceptionsMenu({
            service: props.service,
            commands: {
                registry: props.commands.registry,
                pauseOnExceptions: props.commands.pauseOnExceptions
            }
        });
        this.node.className = PAUSE_ON_EXCEPTION_CLASS;
        this._props = props;
        this._props.className = PAUSE_ON_EXCEPTION_BUTTON_CLASS;
        this._props.service.eventMessage.connect((_, event) => {
            if (event.event === 'initialized' || event.event === 'terminated') {
                this.onChange();
            }
        }, this);
        this._props.enabled = this._props.service.pauseOnExceptionsIsValid();
        this._props.service.pauseOnExceptionChanged.connect(this.onChange, this);
    }
    /**
     * Called when the debugger is initialized or the filter changed.
     */
    onChange() {
        var _a;
        const session = this._props.service.session;
        const exceptionBreakpointFilters = session === null || session === void 0 ? void 0 : session.exceptionBreakpointFilters;
        this._props.className = PAUSE_ON_EXCEPTION_BUTTON_CLASS;
        if (((_a = this._props.service.session) === null || _a === void 0 ? void 0 : _a.isStarted) && exceptionBreakpointFilters) {
            if (session.isPausingOnException()) {
                this._props.className += ' lm-mod-toggled';
            }
            this._props.enabled = true;
        }
        else {
            this._props.enabled = false;
        }
        this.update();
    }
    render() {
        return React.createElement(ToolbarButtonComponent, { ...this._props, onClick: this.onclick });
    }
}
/**
 * A menu with all the available filter from the debugger as entries.
 */
export class PauseOnExceptionsMenu extends MenuSvg {
    /**
     * The constructor of the menu.
     */
    constructor(props) {
        super({ commands: props.commands.registry });
        this._service = props.service;
        this._command = props.commands.pauseOnExceptions;
        props.service.eventMessage.connect((_, event) => {
            if (event.event === 'initialized') {
                this._build();
            }
        }, this);
        this._build();
        this.addClass(PAUSE_ON_EXCEPTION_MENU_CLASS);
    }
    _build() {
        var _a, _b;
        this.clearItems();
        const exceptionsBreakpointFilters = (_b = (_a = this._service.session) === null || _a === void 0 ? void 0 : _a.exceptionBreakpointFilters) !== null && _b !== void 0 ? _b : [];
        exceptionsBreakpointFilters.map((filter, _) => {
            this.addItem({
                command: this._command,
                args: {
                    filter: filter.filter,
                    description: filter.description
                }
            });
        });
    }
}
//# sourceMappingURL=pauseonexceptions.js.map