import { MenuSvg, ToolbarButton, ToolbarButtonComponent } from '@jupyterlab/ui-components';
import { IDebugger } from '../../tokens';
import { Breakpoints } from './index';
/**
 * A button which display a menu on click, to select the filter.
 */
export declare class PauseOnExceptionsWidget extends ToolbarButton {
    /**
     * Constructor of the button.
     */
    constructor(props: PauseOnExceptions.IProps);
    /**
     * Called when the debugger is initialized or the filter changed.
     */
    onChange(): void;
    /**
     * open menu on click.
     */
    onclick: () => void;
    render(): JSX.Element;
    private _menu;
    private _props;
}
/**
 * A menu with all the available filter from the debugger as entries.
 */
export declare class PauseOnExceptionsMenu extends MenuSvg {
    /**
     * The constructor of the menu.
     */
    constructor(props: PauseOnExceptions.IProps);
    private _build;
    private _service;
    private _command;
}
/**
 * A namespace for the widget.
 */
export declare namespace PauseOnExceptions {
    /**
     * The properties of the widget and menu.
     */
    interface IProps extends ToolbarButtonComponent.IProps {
        /**
         * The debugger service linked to the widget.
         */
        service: IDebugger;
        /**
         * The commands registry and the command ID associated to the menu.
         */
        commands: Breakpoints.ICommands;
    }
}
