// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { Signal } from '@lumino/signaling';
import { EditorHandler } from '../handlers/editor';
/**
 * A handler for files.
 */
export class FileHandler {
    /**
     * Instantiate a new FileHandler.
     *
     * @param options The instantiation options for a FileHandler.
     */
    constructor(options) {
        var _a;
        this._debuggerService = options.debuggerService;
        this._fileEditor = options.widget.content;
        this._hasLineNumber =
            (_a = this._fileEditor.editor.getOption('lineNumbers')) !== null && _a !== void 0 ? _a : false;
        this._editorHandler = new EditorHandler({
            debuggerService: this._debuggerService,
            editorReady: () => Promise.resolve(this._fileEditor.editor),
            getEditor: () => this._fileEditor.editor,
            src: this._fileEditor.model.sharedModel
        });
    }
    /**
     * Dispose the handler.
     */
    dispose() {
        var _a, _b;
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        (_a = this._editorHandler) === null || _a === void 0 ? void 0 : _a.dispose();
        // Restore editor options
        (_b = this._editorHandler) === null || _b === void 0 ? void 0 : _b.editor.setOptions({
            lineNumbers: this._hasLineNumber
        });
        Signal.clearData(this);
    }
}
//# sourceMappingURL=file.js.map