import { CodeEditor, IEditorFactoryService } from '@jupyterlab/codeeditor';
import { ITranslator } from '@jupyterlab/translation';
import { CodeMirrorEditor } from './editor';
import { IEditorExtensionFactory, IEditorExtensionRegistry, IEditorFactoryOptions, IEditorLanguageRegistry } from './token';
/**
 * CodeMirror editor factory.
 */
export declare class CodeMirrorEditorFactory implements IEditorFactoryService {
    /**
     * Construct an IEditorFactoryService for CodeMirrorEditors.
     */
    constructor(options?: IEditorFactoryOptions);
    /**
     * Create a new editor for inline code.
     */
    readonly newInlineEditor: (options: CodeEditor.IOptions) => CodeMirrorEditor;
    /**
     * Create a new editor for a full document.
     */
    readonly newDocumentEditor: (options: CodeEditor.IOptions) => CodeMirrorEditor;
    /**
     * Create a new editor
     *
     * @param options Editor options
     * @returns The editor
     */
    protected newEditor(options: CodeEditor.IOptions & IEditorExtensionFactory.IOptions): CodeMirrorEditor;
    protected extensions: IEditorExtensionRegistry;
    protected languages: IEditorLanguageRegistry;
    protected translator: ITranslator;
    protected inlineCodeMirrorConfig: Record<string, any>;
    protected documentCodeMirrorConfig: Record<string, any>;
}
