/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
import { combineConfig, Facet } from '@codemirror/state';
import { EditorView } from '@codemirror/view';
/**
 * Custom theme configuration
 *
 * The first non-null value takes precedence
 */
const customThemeConfig = Facet.define({
    combine(configs) {
        return combineConfig(configs, {
            fontFamily: null,
            fontSize: null,
            lineHeight: null
        }, {
            fontFamily: (a, b) => a !== null && a !== void 0 ? a : b,
            fontSize: (a, b) => a !== null && a !== void 0 ? a : b,
            lineHeight: (a, b) => a !== null && a !== void 0 ? a : b
        });
    }
});
function setEditorStyle(view) {
    const { fontFamily, fontSize, lineHeight } = view.state.facet(customThemeConfig);
    let style = '';
    if (fontSize) {
        style += `font-size: ${fontSize}px !important;`;
    }
    if (fontFamily) {
        style += `font-family: ${fontFamily} !important;`;
    }
    if (lineHeight) {
        style += `line-height: ${lineHeight.toString()} !important`;
    }
    return { style: style };
}
/**
 * Get the extension to customize an editor theme.
 *
 * @param config Theme customization
 * @returns Editor extension
 */
export function customTheme(config) {
    return [
        customThemeConfig.of(config),
        EditorView.editorAttributes.of(setEditorStyle)
    ];
}
//# sourceMappingURL=customStyle.js.map