"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ROLES = exports.PACKAGE_ACCESS = void 0;
exports.buildUserBuffer = buildUserBuffer;
exports.createSessionToken = createSessionToken;
exports.getAuthenticatedMessage = getAuthenticatedMessage;
function createSessionToken() {
  const tenHoursTime = 10 * 60 * 60 * 1000;
  return {
    // npmjs.org sets 10h expire
    expires: new Date(Date.now() + tenHoursTime)
  };
}
function getAuthenticatedMessage(user) {
  return `you are authenticated as '${user}'`;
}
function buildUserBuffer(name, password) {
  return Buffer.from(`${name}:${password}`, 'utf8');
}
const ROLES = {
  $ALL: '$all',
  ALL: 'all',
  $AUTH: '$authenticated',
  $ANONYMOUS: '$anonymous',
  DEPRECATED_ALL: '@all',
  DEPRECATED_AUTH: '@authenticated',
  DEPRECATED_ANONYMOUS: '@anonymous'
};
exports.ROLES = ROLES;
const PACKAGE_ACCESS = {
  SCOPE: '@*/*',
  ALL: '**'
};
exports.PACKAGE_ACCESS = PACKAGE_ACCESS;
//# sourceMappingURL=auth-utils.js.map