"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _express = _interopRequireDefault(require("express"));
var _renderWeb = require("./render-web");
var _webApi = require("./web-api");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var _default = (config, middlewares, pluginOptions) => {
  // eslint-disable-next-line new-cap
  const router = _express.default.Router();
  const {
    tokenMiddleware,
    webEndpointsApi
  } = middlewares;
  // render web
  router.use('/', (0, _renderWeb.renderWebMiddleware)(config, tokenMiddleware, pluginOptions));
  // web endpoints, search, packages, etc
  router.use('/-/verdaccio/', (0, _webApi.webMiddleware)(tokenMiddleware, webEndpointsApi));
  return router;
};
exports.default = _default;
//# sourceMappingURL=web-middleware.js.map