"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.webMiddleware = webMiddleware;
var _express = _interopRequireWildcard(require("express"));
var _validation = require("../validation");
var _security = require("./security");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function webMiddleware(tokenMiddleware, webEndpointsApi) {
  // eslint-disable-next-line new-cap
  const route = (0, _express.Router)();
  // validate all of these params as a package name
  // this might be too harsh, so ask if it causes trouble=
  route.param('package', _validation.validatePackage);
  route.param('filename', _validation.validateName);
  route.param('version', _validation.validateName);
  route.use(_express.default.urlencoded({
    extended: false
  }));
  if (typeof tokenMiddleware === 'function') {
    route.use(tokenMiddleware);
  }
  route.use(_security.setSecurityWebHeaders);
  if (webEndpointsApi) {
    route.use(webEndpointsApi);
  }
  return route;
}
//# sourceMappingURL=web-api.js.map