"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasLogin = hasLogin;
exports.validatePrimaryColor = validatePrimaryColor;
var _debug = _interopRequireDefault(require("debug"));
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:web:middlwares');
function validatePrimaryColor(primaryColor) {
  const isHex = /^#([0-9A-F]{3}){1,2}$/i.test(primaryColor);
  if (!isHex) {
    debug('invalid primary color %o', primaryColor);
    return;
  }
  return primaryColor;
}
function hasLogin(config) {
  var _config$web, _config$web2;
  return _lodash.default.isNil(config === null || config === void 0 ? void 0 : (_config$web = config.web) === null || _config$web === void 0 ? void 0 : _config$web.login) || (config === null || config === void 0 ? void 0 : (_config$web2 = config.web) === null || _config$web2 === void 0 ? void 0 : _config$web2.login) === true;
}
//# sourceMappingURL=web-utils.js.map