"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderTemplate;
var _debug = _interopRequireDefault(require("debug"));
var _manifest = require("./manifest");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:web:render:template');
function renderTemplate(template, manifest) {
  var _template$options$tit, _template$options;
  debug('template %o', template);
  debug('manifest %o', manifest);
  return `
    <!DOCTYPE html>
      <html lang="en-us"> 
      <head>
        <meta charset="utf-8">
        <base href="${template === null || template === void 0 ? void 0 : template.options.base}">
        <title>${(_template$options$tit = template === null || template === void 0 ? void 0 : (_template$options = template.options) === null || _template$options === void 0 ? void 0 : _template$options.title) !== null && _template$options$tit !== void 0 ? _template$options$tit : ''}</title>        
        <link rel="icon" href="${template === null || template === void 0 ? void 0 : template.options.base}-/static/favicon.ico"/>
        <meta name="viewport" content="width=device-width, initial-scale=1" /> 
        <script>
            window.__VERDACCIO_BASENAME_UI_OPTIONS=${JSON.stringify(template.options)}
        </script>
        ${template !== null && template !== void 0 && template.metaScripts ? template.metaScripts.join('') : ''}
      </head>    
      <body class="body">
      ${template !== null && template !== void 0 && template.scriptsbodyBefore ? template.scriptsbodyBefore.join('') : ''}
        <div id="root"></div>
        ${(0, _manifest.getManifestValue)(template.manifest.js, manifest, template === null || template === void 0 ? void 0 : template.options.base).map(item => `<script defer="defer" src="${item}"></script>`).join('')}
        ${template !== null && template !== void 0 && template.scriptsBodyAfter ? template.scriptsBodyAfter.join('') : ''}
      </body>
    </html>
  `;
}
//# sourceMappingURL=template.js.map