"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderHTML;
exports.resolveLogo = resolveLogo;
var _debug = _interopRequireDefault(require("debug"));
var _lruCache = _interopRequireDefault(require("lru-cache"));
var _path = _interopRequireDefault(require("path"));
var _url = require("url");
var _config = require("@verdaccio/config");
var _core = require("@verdaccio/core");
var _url2 = require("@verdaccio/url");
var _template = _interopRequireDefault(require("./template"));
var _webUtils = require("./web-utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const DEFAULT_LANGUAGE = 'es-US';
const cache = new _lruCache.default({
  max: 500,
  ttl: 1000 * 60 * 60
});
const debug = (0, _debug.default)('verdaccio:web:render');
const defaultManifestFiles = {
  js: ['runtime.js', 'vendors.js', 'main.js'],
  ico: 'favicon.ico'
};
function resolveLogo(config, req) {
  var _config$web, _config$web2, _config$web4;
  const isLocalFile = (config === null || config === void 0 ? void 0 : (_config$web = config.web) === null || _config$web === void 0 ? void 0 : _config$web.logo) && !(0, _url2.isURLhasValidProtocol)(config === null || config === void 0 ? void 0 : (_config$web2 = config.web) === null || _config$web2 === void 0 ? void 0 : _config$web2.logo);
  if (isLocalFile) {
    var _config$web3;
    return `${(0, _url2.getPublicUrl)(config === null || config === void 0 ? void 0 : config.url_prefix, req)}-/static/${_path.default.basename(config === null || config === void 0 ? void 0 : (_config$web3 = config.web) === null || _config$web3 === void 0 ? void 0 : _config$web3.logo)}`;
  } else if ((0, _url2.isURLhasValidProtocol)(config === null || config === void 0 ? void 0 : (_config$web4 = config.web) === null || _config$web4 === void 0 ? void 0 : _config$web4.logo)) {
    var _config$web5;
    return config === null || config === void 0 ? void 0 : (_config$web5 = config.web) === null || _config$web5 === void 0 ? void 0 : _config$web5.logo;
  } else {
    return '';
  }
}
function renderHTML(config, manifest, manifestFiles, req, res) {
  var _config$i18n$web, _config$i18n, _config$web6, _config$web$darkMode, _config$web7, _config$web$title, _config$web8, _config$web$scope, _config$web9, _config$web$pkgManage, _config$web10, _config$web11, _validatePrimaryColor, _config$web12;
  const {
    url_prefix
  } = config;
  const base = (0, _url2.getPublicUrl)(config === null || config === void 0 ? void 0 : config.url_prefix, req);
  const basename = new _url.URL(base).pathname;
  const language = (_config$i18n$web = config === null || config === void 0 ? void 0 : (_config$i18n = config.i18n) === null || _config$i18n === void 0 ? void 0 : _config$i18n.web) !== null && _config$i18n$web !== void 0 ? _config$i18n$web : DEFAULT_LANGUAGE;
  const needHtmlCache = [undefined, null].includes(config === null || config === void 0 ? void 0 : (_config$web6 = config.web) === null || _config$web6 === void 0 ? void 0 : _config$web6.html_cache) ? true : config.web.html_cache;
  const darkMode = (_config$web$darkMode = config === null || config === void 0 ? void 0 : (_config$web7 = config.web) === null || _config$web7 === void 0 ? void 0 : _config$web7.darkMode) !== null && _config$web$darkMode !== void 0 ? _config$web$darkMode : false;
  const title = (_config$web$title = config === null || config === void 0 ? void 0 : (_config$web8 = config.web) === null || _config$web8 === void 0 ? void 0 : _config$web8.title) !== null && _config$web$title !== void 0 ? _config$web$title : _config.WEB_TITLE;
  const login = (0, _webUtils.hasLogin)(config);
  const scope = (_config$web$scope = config === null || config === void 0 ? void 0 : (_config$web9 = config.web) === null || _config$web9 === void 0 ? void 0 : _config$web9.scope) !== null && _config$web$scope !== void 0 ? _config$web$scope : '';
  const logo = resolveLogo(config, req);
  const pkgManagers = (_config$web$pkgManage = config === null || config === void 0 ? void 0 : (_config$web10 = config.web) === null || _config$web10 === void 0 ? void 0 : _config$web10.pkgManagers) !== null && _config$web$pkgManage !== void 0 ? _config$web$pkgManage : ['yarn', 'pnpm', 'npm'];
  const version = config === null || config === void 0 ? void 0 : (_config$web11 = config.web) === null || _config$web11 === void 0 ? void 0 : _config$web11.version;
  const flags = {
    ...config.flags,
    // legacy from 5.x
    ...config.experiments
  };
  const primaryColor = (_validatePrimaryColor = (0, _webUtils.validatePrimaryColor)(config === null || config === void 0 ? void 0 : (_config$web12 = config.web) === null || _config$web12 === void 0 ? void 0 : _config$web12.primary_color)) !== null && _validatePrimaryColor !== void 0 ? _validatePrimaryColor : '#4b5e40';
  const {
    scriptsBodyAfter,
    metaScripts,
    scriptsbodyBefore,
    showInfo,
    showSettings,
    showThemeSwitch,
    showFooter,
    showSearch,
    showDownloadTarball
  } = Object.assign({}, {
    scriptsBodyAfter: [],
    bodyBefore: [],
    metaScripts: []
  }, config === null || config === void 0 ? void 0 : config.web);
  const options = {
    showInfo,
    showSettings,
    showThemeSwitch,
    showFooter,
    showSearch,
    showDownloadTarball,
    darkMode,
    url_prefix,
    basename,
    base,
    primaryColor,
    version,
    logo,
    flags,
    login,
    pkgManagers,
    title,
    scope,
    language
  };
  let webPage;
  try {
    webPage = cache.get('template');
    if (!webPage) {
      webPage = (0, _template.default)({
        manifest: manifestFiles !== null && manifestFiles !== void 0 ? manifestFiles : defaultManifestFiles,
        options,
        scriptsBodyAfter,
        metaScripts,
        scriptsbodyBefore
      }, manifest);
      if (needHtmlCache) {
        cache.set('template', webPage);
        debug('set template cache');
      }
    } else {
      debug('reuse template cache');
    }
  } catch (error) {
    throw new Error(`theme could not be load, stack ${error.stack}`);
  }
  res.setHeader('Content-Type', _core.HEADERS.TEXT_HTML);
  res.send(webPage);
  debug('web rendered');
}
//# sourceMappingURL=renderHTML.js.map