"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setSecurityWebHeaders = setSecurityWebHeaders;
var _core = require("@verdaccio/core");
function setSecurityWebHeaders(_req, res, next) {
  // disable loading in frames (clickjacking, etc.)
  res.header(_core.HEADERS.FRAMES_OPTIONS, 'deny');
  // avoid stablish connections outside of domain
  res.header(_core.HEADERS.CSP, "connect-src 'self'");
  // https://stackoverflow.com/questions/18337630/what-is-x-content-type-options-nosniff
  res.header(_core.HEADERS.CTO, 'nosniff');
  // https://stackoverflow.com/questions/9090577/what-is-the-http-header-x-xss-protection
  res.header(_core.HEADERS.XSS, '1; mode=block');
  next();
}
//# sourceMappingURL=security.js.map