"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderWebMiddleware = renderWebMiddleware;
var _debug = _interopRequireDefault(require("debug"));
var _express = _interopRequireDefault(require("express"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _core = require("@verdaccio/core");
var _url = require("@verdaccio/url");
var _security = require("./security");
var _renderHTML = _interopRequireDefault(require("./utils/renderHTML"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:web:render');
const sendFileCallback = next => err => {
  if (!err) {
    return;
  }
  if (err.status === _core.HTTP_STATUS.NOT_FOUND) {
    next();
  } else {
    next(err);
  }
};
function renderWebMiddleware(config, tokenMiddleware, pluginOptions) {
  var _config$web, _config$web2;
  const {
    staticPath,
    manifest,
    manifestFiles
  } = pluginOptions;
  debug('static path %o', staticPath);

  /* eslint new-cap:off */
  const router = _express.default.Router();
  if (typeof tokenMiddleware === 'function') {
    router.use(tokenMiddleware);
  }
  router.use(_security.setSecurityWebHeaders);

  // any match within the static is routed to the file system
  router.get('/-/static/*', function (req, res, next) {
    const filename = req.params[0];
    const file = `${staticPath}/${filename}`;
    debug('render static file %o', file);
    res.sendFile(file, sendFileCallback(next));
  });

  // check the origin of the logo
  if (config !== null && config !== void 0 && (_config$web = config.web) !== null && _config$web !== void 0 && _config$web.logo && !(0, _url.isURLhasValidProtocol)(config === null || config === void 0 ? void 0 : (_config$web2 = config.web) === null || _config$web2 === void 0 ? void 0 : _config$web2.logo)) {
    // URI related to a local file
    const absoluteLocalFile = _path.default.posix.resolve(config.web.logo);
    debug('serve local logo %s', absoluteLocalFile);
    try {
      // TODO: replace existsSync by async alternative
      if (_fs.default.existsSync(absoluteLocalFile) && typeof _fs.default.accessSync(absoluteLocalFile, _fs.default.constants.R_OK) === 'undefined') {
        // Note: `path.join` will break on Windows, because it transforms `/` to `\`
        // Use POSIX version `path.posix.join` instead.
        config.web.logo = _path.default.posix.join('/-/static/', _path.default.basename(config.web.logo));
        router.get(config.web.logo, function (_req, res, next) {
          // @ts-ignore
          debug('serve custom logo  web:%s - local:%s', config.web.logo, absoluteLocalFile);
          res.sendFile(absoluteLocalFile, sendFileCallback(next));
        });
        debug('enabled custom logo %s', config.web.logo);
      } else {
        config.web.logo = undefined;
        debug(`web logo is wrong, path ${absoluteLocalFile} does not exist or is not readable`);
      }
    } catch {
      config.web.logo = undefined;
      debug(`web logo is wrong, path ${absoluteLocalFile} does not exist or is not readable`);
    }
  }
  router.get('/-/web/:section/*', function (req, res) {
    (0, _renderHTML.default)(config, manifest, manifestFiles, req, res);
    debug('render html section');
  });
  router.get('/', function (req, res) {
    (0, _renderHTML.default)(config, manifest, manifestFiles, req, res);
    debug('render root');
  });
  return router;
}
//# sourceMappingURL=render-web.js.map