"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateName = validateName;
exports.validatePackage = validatePackage;
var _core = require("@verdaccio/core");
var _utils = require("@verdaccio/utils");
function validateName(_req, _res, next, value, name) {
  if (value === '-') {
    // special case in couchdb usually
    next('route');
  } else if ((0, _utils.validateName)(value)) {
    next();
  } else {
    next(_core.errorUtils.getForbidden('invalid ' + name));
  }
}
function validatePackage(_req, _res, next, value, name) {
  if (value === '-') {
    // special case in couchdb usually
    next('route');
  } else if ((0, _utils.validatePackage)(value)) {
    next();
  } else {
    next(_core.errorUtils.getForbidden('invalid ' + name));
  }
}
//# sourceMappingURL=validation.js.map