"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.final = final;
var _lodash = _interopRequireDefault(require("lodash"));
var _core = require("@verdaccio/core");
var _utils = require("@verdaccio/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function final(body, req, res,
// if we remove `next` breaks test
// eslint-disable-next-line @typescript-eslint/no-unused-vars
next) {
  if (res.statusCode === _core.HTTP_STATUS.UNAUTHORIZED && !res.getHeader(_core.HEADERS.WWW_AUTH)) {
    res.header(_core.HEADERS.WWW_AUTH, `${_core.TOKEN_BASIC}, ${_core.TOKEN_BEARER}`);
  }
  try {
    if (_lodash.default.isString(body) || _lodash.default.isObject(body)) {
      if (!res.get(_core.HEADERS.CONTENT_TYPE)) {
        res.header(_core.HEADERS.CONTENT_TYPE, _core.HEADERS.JSON);
      }
      if (typeof body === 'object' && _lodash.default.isNil(body) === false) {
        if (typeof body.error === 'string') {
          res.locals._verdaccio_error = body.error;
        }
        body = JSON.stringify(body, undefined, '  ') + '\n';
      }

      // don't send etags with errors
      if (!res.statusCode || res.statusCode >= _core.HTTP_STATUS.OK && res.statusCode < _core.HTTP_STATUS.MULTIPLE_CHOICES) {
        res.header(_core.HEADERS.ETAG, '"' + (0, _utils.stringToMD5)(body) + '"');
      }
    } else {
      // send(null), send(204), etc.
    }
  } catch (err) {
    // if verdaccio sends headers first, and then calls res.send()
    // as an error handler, we can't report error properly,
    // and should just close socket
    if (err.message.match(/set headers after they are sent/)) {
      if (_lodash.default.isNil(res.socket) === false) {
        var _res$socket;
        (_res$socket = res.socket) === null || _res$socket === void 0 ? void 0 : _res$socket.destroy();
      }
      return;
    }
    throw err;
  }
  res.send(body);
}
//# sourceMappingURL=final.js.map