"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.antiLoop = antiLoop;
var _core = require("@verdaccio/core");
/**
 * A middleware that avoid a registry points itself as proxy and avoid create infinite loops.
 * @param config
 * @returns
 */
function antiLoop(config) {
  return function (req, res, next) {
    var _req$headers;
    if ((req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : _req$headers.via) != null) {
      var _req$get;
      const arr = (_req$get = req.get('via')) === null || _req$get === void 0 ? void 0 : _req$get.split(',');
      if (Array.isArray(arr)) {
        for (let i = 0; i < arr.length; i++) {
          // the "via" header must contains an specific headers, this has to be on sync
          // with the proxy request
          // match eg: Server 1 or Server 2
          // TODO: improve this RegEX
          const m = arr[i].trim().match(/\s*(\S+)\s+(\S+)/);
          if (m && m[2] === config.server_id) {
            return next(_core.errorUtils.getCode(_core.HTTP_STATUS.LOOP_DETECTED, 'loop detected'));
          }
        }
      }
    }
    next();
  };
}
//# sourceMappingURL=antiLoop.js.map