"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allow = allow;
var _core = require("@verdaccio/core");
var _utils = require("@verdaccio/utils");
function allow(auth, options = {
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  beforeAll: (_a, _b) => {},
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  afterAll: (_a, _b) => {}
}) {
  const {
    beforeAll,
    afterAll
  } = options;
  return function (action) {
    return function (req, res, next) {
      req.pause();
      const packageName = req.params.scope ? `@${req.params.scope}/${req.params.package}` : req.params.package;
      const packageVersion = req.params.filename ? (0, _utils.getVersionFromTarball)(req.params.filename) : undefined;
      const remote = req.remote_user;
      beforeAll === null || beforeAll === void 0 ? void 0 : beforeAll({
        action,
        user: remote === null || remote === void 0 ? void 0 : remote.name
      }, `[middleware/allow][@{action}] allow for @{user}`);
      auth['allow_' + action]({
        packageName,
        packageVersion
      }, remote, function (error, allowed) {
        req.resume();
        if (error) {
          next(error);
        } else if (allowed) {
          afterAll === null || afterAll === void 0 ? void 0 : afterAll({
            action,
            user: remote === null || remote === void 0 ? void 0 : remote.name
          }, `[middleware/allow][@{action}] allowed for @{user}`);
          next();
        } else {
          // last plugin (that's our built-in one) returns either
          // cb(err) or cb(null, true), so this should never happen
          throw _core.errorUtils.getInternalError(_core.API_ERROR.PLUGIN_ERROR);
        }
      });
    };
  };
}
//# sourceMappingURL=allow.js.map