import os
from codecs import open
from setuptools import setup, find_namespace_packages

here = os.path.abspath(os.path.dirname(__file__))

about = {}
with open(os.path.join(here, "interva", "__version__.py"), "r", "utf-8") as f:
    exec(f.read(), about)

with open("README.md", "r", "utf-8") as f:
    readme = f.read()


setup(
    name=about["__title__"],
    version=about["__version__"],
    author=about["__author__"],
    author_email=about["__author_email__"],
    description=about["__description__"],
    long_description=readme,
    long_description_content_type="text/markdown",
    url=about["__url__"],
    license=about["__license__"],
    packages=find_namespace_packages(),
    include_package_data=True,
    package_dir={"": "."},
    package_data={
        "interva.data": ["*.csv", "*.xls"],
    },
    install_requires=[
        "pandas",
        "xlrd",
        "numpy",
        "vacheck",
        ],
    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Operating System :: OS Independent",
    ],
)
