# -*- coding: utf-8 -*-

"""
interva.data.causetext
~~~~~~~~~~~~~~
This module creates data used by InterVA.
"""

CAUSETEXTV5 = {
    "a_nrp": {"cause": "Not pregnant or recently delivered",
              "code": "Not pregnant or recently delivered"},
    "a_pend_6w": {"cause": "Pregnancy ended within 6 weeks of death",
                  "code": "Pregnancy ended within 6 weeks of death"},
    "a_preg": {"cause": "Pregnant at death",
               "code": "Pregnant at death"},
    "b_0101": {"cause": "Sepsis (non-obstetric)", 
               "code": 1.01},
    "b_0102": {"cause": "Acute resp infect incl pneumonia",
               "code": 1.02},
    "b_0103": {"cause": "HIV/AIDS related death",
               "code": 1.03},
    "b_0104": {"cause": "Diarrhoeal diseases",
               "code": 1.04},
    "b_0105": {"cause": "Malaria",
               "code": 1.05},
    "b_0106": {"cause": "Measles",
               "code": 1.06},
    "b_0107": {"cause": "Meningitis and encephalitis",
               "code": 1.07},
    "b_0108": {"cause": "Tetanus",
               "code": 1.08},
    "b_0109": {"cause": "Pulmonary tuberculosis",
               "code": 1.09},
    "b_0110": {"cause": "Pertussis",
               "code": 1.10},
    "b_0111": {"cause": "Haemorrhagic fever (non-dengue)",
               "code": 1.11},
    "b_0112": {"cause": "Dengue fever",
               "code": 1.12},
    "b_0199": {"cause": "Other and unspecified infect dis",
               "code": 1.99},
    "b_0201": {"cause": "Oral neoplasms",
               "code": 2.01},
    "b_0202": {"cause": "Digestive neoplasms",
               "code": 2.02},
    "b_0203": {"cause": "Respiratory neoplasms",
               "code": 2.03},
    "b_0204": {"cause": "Breast neoplasms",
               "code": 2.04},
    "b_0205": {"cause": "Reproductive neoplasms MF",
               "code": 2.05},
    "b_0299": {"cause": "Other and unspecified neoplasms",
               "code": 2.99},
    "b_0301": {"cause": "Severe anaemia",
               "code": 3.01},
    "b_0302": {"cause": "Severe malnutrition",
               "code": 3.02},
    "b_0303": {"cause": "Diabetes mellitus",
               "code": 3.03},
    "b_0401": {"cause": "Acute cardiac disease",
               "code": 4.01},
    "b_0402": {"cause": "Stroke",
               "code": 4.02},
    "b_0403": {"cause": "Sickle cell with crisis",
               "code": 4.03},
    "b_0499": {"cause": "Other and unspecified cardiac dis",
               "code": 4.99},
    "b_0501": {"cause": "Chronic obstructive pulmonary dis",
               "code": 5.01},
    "b_0502": {"cause": "Asthma",
               "code": 5.02},
    "b_0601": {"cause": "Acute abdomen",
               "code": 6.01},
    "b_0602": {"cause": "Liver cirrhosis",
               "code": 6.02},
    "b_0701": {"cause": "Renal failure",
               "code": 7.01},
    "b_0801": {"cause": "Epilepsy",
               "code": 8.01},
    "b_0901": {"cause": "Ectopic pregnancy",
               "code": 9.01},
    "b_0902": {"cause": "Abortion-related death",
               "code": 9.02},
    "b_0903": {"cause": "Pregnancy-induced hypertension",
               "code": 9.03},
    "b_0904": {"cause": "Obstetric haemorrhage",
               "code": 9.04},
    "b_0905": {"cause": "Obstructed labour",
               "code": 9.05},
    "b_0906": {"cause": "Pregnancy-related sepsis",
               "code": 9.06},
    "b_0907": {"cause": "Anaemia of pregnancy",
               "code": 9.07},
    "b_0908": {"cause": "Ruptured uterus",
               "code": 9.08},
    "b_0999": {"cause": "Other and unspecified maternal CoD",
               "code": 9.99},
    "b_1001": {"cause": "Prematurity",
               "code": 10.01},
    "b_1002": {"cause": "Birth asphyxia",
               "code": 10.02},
    "b_1003": {"cause": "Neonatal pneumonia",
               "code": 10.03},
    "b_1004": {"cause": "Neonatal sepsis",
               "code": 10.04},
    "b_1006": {"cause": "Congenital malformation",
               "code": 10.06},
    "b_1099": {"cause": "Other and unspecified neonatal CoD",
               "code": 10.99},
    "b_1101": {"cause": "Fresh stillbirth",
               "code": 11.01},
    "b_1102": {"cause": "Macerated stillbirth",
               "code": 11.02},
    "b_1201": {"cause": "Road traffic accident",
               "code": 12.01},
    "b_1202": {"cause": "Other transport accident",
               "code": 12.02},
    "b_1203": {"cause": "Accid fall",
               "code": 12.03},
    "b_1204": {"cause": "Accid drowning and submersion",
               "code": 12.04},
    "b_1205": {"cause": "Accid expos to smoke fire & flame",
               "code": 12.05},
    "b_1206": {"cause": "Contact with venomous plant/animal",
               "code": 12.06},
    "b_1207": {"cause": "Accid poisoning & noxious subs",
               "code": 12.07},
    "b_1208": {"cause": "Intentional self-harm",
               "code": 12.08},
    "b_1209": {"cause": "Assault",
               "code": 12.09},
    "b_1210": {"cause": "Exposure to force of nature",
               "code": 12.10},
    "b_1299": {"cause": "Other and unspecified external CoD",
               "code": 12.99},
    "b_9800": {"cause": "Other and unspecified NCD",
               "code": 98},
    "c_cult": {"cause": "Culture",
               "code": "Culture"},
    "c_emer": {"cause": "Emergency",
               "code": "Emergency"},
    "c_hsys": {"cause": "Health systems",
               "code": "Health"},
    "c_inev": {"cause": "Inevitable",
               "code": "Inevitable"},
    "c_know": {"cause": "Knowledge",
               "code": "Knowledge"},
    "c_resr": {"cause": "Resources",
               "code": "Resources"}
}
