# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': '.'}

packages = \
['etna',
 'etna.analysis',
 'etna.analysis.change_points_trend',
 'etna.analysis.feature_relevance',
 'etna.analysis.feature_selection',
 'etna.analysis.outliers',
 'etna.clustering',
 'etna.clustering.distances',
 'etna.clustering.hierarchical',
 'etna.commands',
 'etna.core',
 'etna.datasets',
 'etna.ensembles',
 'etna.libs.tsfresh',
 'etna.loggers',
 'etna.metrics',
 'etna.models',
 'etna.models.nn',
 'etna.pipeline',
 'etna.transforms',
 'etna.transforms.decomposition',
 'etna.transforms.encoders',
 'etna.transforms.feature_selection',
 'etna.transforms.math',
 'etna.transforms.missing_values',
 'etna.transforms.nn',
 'etna.transforms.outliers',
 'etna.transforms.timestamp']

package_data = \
{'': ['*']}

install_requires = \
['Bottleneck>=1.3.4,<2.0.0',
 'boto3>=1.5,<2.0',
 'botocore',
 'catboost>=0.21',
 'dill>=0.3.4,<0.4.0',
 'holidays>=0.11.3,<0.12.0',
 'hydra-slayer>=0.2.0,<0.3.0',
 'hydra_slayer',
 'joblib',
 'loguru>=0.5.3,<0.6.0',
 'matplotlib',
 'numba>=0.53.1,<0.56.0',
 'numpy',
 'omegaconf>=2.1.1,<3.0.0',
 'pandas>=1,<2',
 'plotly',
 'ruptures==1.1.5',
 'scikit-learn>=0.24,<2',
 'scipy<1.8.0',
 'seaborn>=0.11.1,<0.12.0',
 'statsmodels>=0.12,<0.14',
 'toml>=0.10.2,<0.11.0',
 'typer>=0.4.0,<0.5.0',
 'typing_extensions']

extras_require = \
{'all': ['prophet>=1.0,<2.0',
         'torch>=1.8.0,<1.12.0',
         'pytorch-forecasting>=0.9.0,<0.10.0',
         'wandb>=0.12.2,<0.13.0'],
 'all-dev': ['prophet>=1.0,<2.0',
             'torch>=1.8.0,<1.12.0',
             'pytorch-forecasting>=0.9.0,<0.10.0',
             'wandb>=0.12.2,<0.13.0',
             'sphinx-mathjax-offline>=0.0.1,<0.0.2',
             'nbsphinx>=0.8.2,<0.9.0',
             'Sphinx>=4.1,<5.0',
             'numpydoc>=1.1.0,<2.0.0',
             'sphinx-rtd-theme>=0.5.1,<0.6.0',
             'myst-parser>=0.15.0,<0.16.0',
             'GitPython>=3.1.20,<4.0.0',
             'pytest>=6.2,<7.0',
             'coverage>=5.4,<6.0',
             'pytest-cov>=2.11.1,<3.0.0',
             'black==21.9b0',
             'isort>=5.8.0,<6.0.0',
             'flake8>=3.9.2,<4.0.0',
             'flake8-mutable>=1.2.0,<2.0.0',
             'pep8-naming>=0.12.1,<0.13.0',
             'flake8-docstrings>=1.6.0,<2.0.0',
             'mypy>=0.910,<0.911',
             'types-PyYAML>=6.0.0,<7.0.0',
             'codespell>=2.0.0,<3.0.0',
             'click>=8.0.1,<8.1',
             'click>=8.0.1,<8.1',
             'semver>=2.13.0,<3.0.0',
             'semver>=2.13.0,<3.0.0',
             'jupyter',
             'nbconvert'],
 'docs': ['sphinx-mathjax-offline>=0.0.1,<0.0.2',
          'nbsphinx>=0.8.2,<0.9.0',
          'Sphinx>=4.1,<5.0',
          'numpydoc>=1.1.0,<2.0.0',
          'sphinx-rtd-theme>=0.5.1,<0.6.0',
          'myst-parser>=0.15.0,<0.16.0',
          'GitPython>=3.1.20,<4.0.0'],
 'jupyter': ['jupyter', 'nbconvert'],
 'prophet': ['prophet>=1.0,<2.0'],
 'release': ['click>=8.0.1,<8.1', 'semver>=2.13.0,<3.0.0'],
 'style': ['black==21.9b0',
           'isort>=5.8.0,<6.0.0',
           'flake8>=3.9.2,<4.0.0',
           'flake8-mutable>=1.2.0,<2.0.0',
           'pep8-naming>=0.12.1,<0.13.0',
           'flake8-docstrings>=1.6.0,<2.0.0',
           'mypy>=0.910,<0.911',
           'types-PyYAML>=6.0.0,<7.0.0',
           'codespell>=2.0.0,<3.0.0'],
 'tests': ['pytest>=6.2,<7.0',
           'coverage>=5.4,<6.0',
           'pytest-cov>=2.11.1,<3.0.0'],
 'torch': ['torch>=1.8.0,<1.12.0',
           'pytorch-forecasting>=0.9.0,<0.10.0',
           'pytorch-lightning'],
 'wandb': ['wandb>=0.12.2,<0.13.0']}

entry_points = \
{'console_scripts': ['etna = etna.commands.__main__:app']}

setup_kwargs = {
    'name': 'etna',
    'version': '1.9.0',
    'description': 'ETNA is the first python open source framework of Tinkoff.ru AI Center. It is designed to make working with time series simple, productive, and fun.',
    'long_description': '<div align="center">\n<img src="etna_logo.png" width="100%"/>\n</div>\n\n<h3 align="center">Predict your time series the easiest way</h3>\n\n<p align="center">\n  <a href="https://pypi.org/project/etna/"><img alt="PyPI Version" src="https://img.shields.io/pypi/v/etna.svg" /></a>\n  <a href="https://pypi.org/project/etna/"><img alt="Python versions" src="https://img.shields.io/pypi/pyversions/etna.svg" /></a>\n  <a href="https://pepy.tech/project/etna"><img alt="Downloads" src="https://static.pepy.tech/personalized-badge/etna?period=total&units=international_system&left_color=grey&right_color=green&left_text=Downloads" /></a>\n</p>\n \n<p align="center">\n  <a href="https://codecov.io/gh/tinkoff-ai/etna"><img alt="Coverage" src="https://img.shields.io/codecov/c/github/tinkoff-ai/etna.svg" /></a>\n  <a href="https://github.com/tinkoff-ai/etna/actions/workflows/test.yml?query=branch%3Amaster++"><img alt="Test passing" src="https://img.shields.io/github/workflow/status/tinkoff-ai/etna/Test/master?label=tests" /></a>\n  <a href="https://github.com/tinkoff-ai/etna/actions/workflows/publish.yml"><img alt="Docs publish" src="https://img.shields.io/github/workflow/status/tinkoff-ai/etna/Publish?label=docs" /></a>\n  <a href="https://github.com/tinkoff-ai/etna/blob/master/LICENSE"><img alt="License" src="https://img.shields.io/github/license/tinkoff-ai/etna.svg" /></a>\n</p>\n\n<p align="center">\n  <a href="https://t.me/etna_support"><img alt="Telegram" src="https://img.shields.io/badge/channel-telegram-blue" /></a>\n  <a href="https://opendatascience.slack.com/archives/C02Q62NEPH8"><img alt="Slack" src="https://img.shields.io/badge/slack-ods.ai-orange" /></a>\n  <a href="https://github.com/tinkoff-ai/etna/discussions"><img alt="GitHub Discussions" src="https://img.shields.io/github/discussions/tinkoff-ai/etna" /></a>\n  <a href="https://github.com/tinkoff-ai/etna/graphs/contributors"><img alt="Contributors" src="https://img.shields.io/github/contributors/tinkoff-ai/etna.svg" /></a>\n  <a href="https://github.com/tinkoff-ai/etna/stargazers"><img alt="Stars" src="https://img.shields.io/github/stars/tinkoff-ai/etna?style=social" /></a>\n</p>\n\n<p align="center">\n  <a href="https://etna.tinkoff.ru">Homepage</a> | \n  <a href="https://etna-docs.netlify.app/">Documentation</a> |\n  <a href="https://github.com/tinkoff-ai/etna/tree/master/examples">Tutorials</a> |\n  <a href="https://github.com/tinkoff-ai/etna/blob/master/CONTRIBUTING.md">Contribution Guide</a> |\n  <a href="https://github.com/tinkoff-ai/etna/releases">Release Notes</a>\n</p>\n  \nETNA is an easy-to-use time series forecasting framework. \nIt includes built in toolkits for time series preprocessing, feature generation, \na variety of predictive models with unified interface - from classic machine learning\nto SOTA neural networks, models combination methods and smart backtesting.\nETNA is designed to make working with time series simple, productive, and fun. \n\nETNA is the first python open source framework of \n[Tinkoff.ru](https://www.tinkoff.ru/eng/)\nArtificial Intelligence Center. \nThe library started as an internal product in our company - \nwe use it in over 10+ projects now, so we often release updates. \nContributions are welcome - check our [Contribution Guide](https://github.com/tinkoff-ai/etna/blob/master/CONTRIBUTING.md).\n\n## Get started\n\nLet\'s load and prepare the data.\n```python\nimport pandas as pd\nfrom etna.datasets import TSDataset\n\n# Read the data\ndf = pd.read_csv("examples/data/example_dataset.csv")\n\n# Create a TSDataset\ndf = TSDataset.to_dataset(df)\nts = TSDataset(df, freq="D")\n\n# Choose a horizon\nHORIZON = 14\n\n# Make train/test split\ntrain_ts, test_ts = ts.train_test_split(test_size=HORIZON)\n```\n\nDefine transformations and model:\n```python\nfrom etna.models import CatBoostModelMultiSegment\nfrom etna.transforms import DateFlagsTransform\nfrom etna.transforms import DensityOutliersTransform\nfrom etna.transforms import FourierTransform\nfrom etna.transforms import LagTransform\nfrom etna.transforms import LinearTrendTransform\nfrom etna.transforms import MeanTransform\nfrom etna.transforms import SegmentEncoderTransform\nfrom etna.transforms import TimeSeriesImputerTransform\nfrom etna.transforms import TrendTransform\n\n# Prepare transforms\ntransforms = [\n    DensityOutliersTransform(in_column="target", distance_coef=3.0),\n    TimeSeriesImputerTransform(in_column="target", strategy="forward_fill"),\n    LinearTrendTransform(in_column="target"),\n    TrendTransform(in_column="target", out_column="trend"),\n    LagTransform(in_column="target", lags=list(range(HORIZON, 122)), out_column="target_lag"),\n    DateFlagsTransform(week_number_in_month=True, out_column="date_flag"),\n    FourierTransform(period=360.25, order=6, out_column="fourier"),\n    SegmentEncoderTransform(),\n    MeanTransform(in_column=f"target_lag_{HORIZON}", window=12, seasonality=7),\n    MeanTransform(in_column=f"target_lag_{HORIZON}", window=7),\n]\n\n# Prepare model\nmodel = CatBoostModelMultiSegment()\n```\n\nFit `Pipeline` and make a prediction:\n```python\nfrom etna.pipeline import Pipeline\n\n# Create and fit the pipeline\npipeline = Pipeline(model=model, transforms=transforms, horizon=HORIZON)\npipeline.fit(train_ts)\n\n# Make a forecast\nforecast_ts = pipeline.forecast()\n```\n\nLet\'s plot the results:\n```python\nfrom etna.analysis import plot_forecast\n\nplot_forecast(forecast_ts=forecast_ts, test_ts=test_ts, train_ts=train_ts, n_train_samples=50)\n```\n\n![](examples/assets/readme/get_started.png)\n\nPrint the metric value across the segments:\n```python\nfrom etna.metrics import SMAPE\n\nmetric = SMAPE(mode="macro")\nmetric_value = metric(y_true=test_ts, y_pred=forecast_ts)\n>>> {\'segment_b\': 3.3017151519000967, \'segment_c\': 5.270557433427279, \'segment_a\': 5.272811627335398, \'segment_d\': 4.689085450895735}\n```\n\n## Installation \n\nETNA is available on [PyPI](https://pypi.org/project/etna), so you can use `pip` to install it.\n\nInstall default version:\n```bash\npip install --upgrade pip\npip install etna\n```\n\nThe default version doesn\'t contain all the dependencies, because some of them are needed only for specific models, e.g. Prophet, PyTorch.\nAvailable user extensions are the following:\n* `prophet`\n* `torch`\n* `wandb`\n\nInstall extension:\n```bash\npip install etna[extension-name]\n```\n\nInstall all extensions:\n```bash\npip install etna[all]\n```\n\nThere are also developer extensions. All the extensions are listed in [`pyproject.toml`](https://github.com/tinkoff-ai/etna/blob/master/pyproject.toml#L93).\n\nWithout the appropriate extension you will get an `ImportError` trying to import the model that needs it.\nFor example, `etna.models.ProphetModel` needs `prophet` extension and can\'t be used without it.\n\n### Configuration\n\nETNA supports configuration files. It means that library will check that all the specified packages are installed prior to script start and NOT during runtime. \n\nTo set up a configuration for your project you should create a `.etna` file at the project\'s root. To see the available options look at [`Settings`](https://github.com/tinkoff-ai/etna/blob/master/etna/settings.py#L68). There is an [example](https://github.com/tinkoff-ai/etna/tree/master/examples/configs/.etna) of configuration file.\n\n## Tutorials\n\nWe have also prepared a set of tutorials for an easy introduction:\n\n| Notebook     | Interactive launch  |\n|:----------|------:|\n| [Get started](https://github.com/tinkoff-ai/etna/tree/master/examples/get_started.ipynb) | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/tinkoff-ai/etna/master?filepath=examples/get_started.ipynb) |\n| [Backtest](https://github.com/tinkoff-ai/etna/tree/master/examples/backtest.ipynb) | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/tinkoff-ai/etna/master?filepath=examples/backtest.ipynb) |\n| [EDA](https://github.com/tinkoff-ai/etna/tree/master/examples/EDA.ipynb) | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/tinkoff-ai/etna/master?filepath=examples/EDA.ipynb) |\n| [Outliers](https://github.com/tinkoff-ai/etna/tree/master/examples/outliers.ipynb) | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/tinkoff-ai/etna/master?filepath=examples/outliers.ipynb) |\n| [Clustering](https://github.com/tinkoff-ai/etna/tree/master/examples/clustering.ipynb) | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/tinkoff-ai/etna/master?filepath=examples/clustering.ipynb) |\n| [Deep learning models](https://github.com/tinkoff-ai/etna/tree/master/examples/NN_examples.ipynb) | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/tinkoff-ai/etna/master?filepath=examples/NN_examples.ipynb) |\n| [Ensembles](https://github.com/tinkoff-ai/etna/tree/master/examples/ensembles.ipynb) | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/tinkoff-ai/etna/master?filepath=examples/ensembles.ipynb) |\n\n## Documentation\n\nETNA documentation is available [here](https://etna-docs.netlify.app/).\n\n## Community\n\nTo ask the questions or discuss the library you can join our [telegram chat](t.me/etna_support). \n[Discussions section](https://github.com/tinkoff-ai/etna/discussions) on github is also open for this purpose.\n\n## Resources\n\n- [Forecasting with ETNA: Fast and Furious](https://medium.com/its-tinkoff/forecasting-with-etna-fast-and-furious-1b58e1453809) on Medium\n\n- [Tabular Playground Series - Mar 2022 (7th place!)](https://www.kaggle.com/code/chikovalexander/tps-mar-2022-etna/notebook?scriptVersionId=91575908) on Kaggle\n\n- [Store sales prediction with etna library](https://www.kaggle.com/dmitrybunin/store-sales-prediction-with-etna-library?scriptVersionId=81104235) on Kaggle\n\n- [Tabular Playground Series - Jan 2022](https://www.kaggle.com/code/chikovalexander/tps-jan-2022-etna/notebook) on Kaggle\n\n- [EDA notebook for Ubiquant Market Prediction](https://www.kaggle.com/code/martins0n/ubiquant-eda-toy-predictions-etna) on Kaggle\n\n- [PyCon Russia September 2021 talk](https://youtu.be/VxWHLEFgXnE) on YouTube\n\n- ETNA Tutorial [Part 1 (Rus)](https://youtu.be/4iFVRfB2j30), [Part 2 (Rus)](https://youtu.be/Ct9dyUdHlmc),  [Part 3 (Rus)](https://youtu.be/Qof38dtigtE) on YouTube thanks to [RC Gewissta](https://github.com/Gewissta)\n\n## Acknowledgments\n\n### ETNA.Team\n\n[Andrey Alekseev](https://github.com/iKintosh),\n[Nikita Barinov](https://github.com/diadorer),\n[Dmitriy Bunin](https://github.com/Mr-Geekman),\n[Aleksandr Chikov](https://github.com/alex-hse-repository),\n[Vladislav Denisov](https://github.com/v-v-denisov),\n[Martin Gabdushev](https://github.com/martins0n),\n[Sergey Kolesnikov](https://github.com/Scitator),\n[Artem Makhin](https://github.com/Ama16),\n[Ivan Mitskovets](https://github.com/imitskovets),\n[Albina Munirova](https://github.com/albinamunirova),\n[Nikolay Romantsov](https://github.com/WinstonDovlatov),\n[Julia Shenshina](https://github.com/julia-shenshina)\n\n### ETNA.Contributors\n\n[Artem Levashov](https://github.com/soft1q),\n[Aleksey Podkidyshev](https://github.com/alekseyen),\n[Carlosbogo](https://github.com/Carlosbogo)\n\n## License\n\nFeel free to use our library in your commercial and private applications.\n\nETNA is covered by [Apache 2.0](/LICENSE). \nRead more about this license [here](https://choosealicense.com/licenses/apache-2.0/)\n\n> Please note that `etna[prophet]` is covered by [GPL 2.0](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html) due to pystan package.\n',
    'author': 'Andrey Alekseev',
    'author_email': 'an.alekseev@tinkoff.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tinkoff-ai/etna',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<3.10.0',
}


setup(**setup_kwargs)
